package io.github.prospector.modmenu.gui;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_669;
import net.minecraft.class_679;
import net.minecraft.class_698;
import io.github.prospector.modmenu.util.HardcodedUtil;

public class DescriptionListWidget extends class_698 {
	private final ModListScreen parent;
	private final class_679 textRenderer;
	private ModListEntry lastSelected = null;
	private List<DescriptionEntry> entries = new LinkedList<>();

	public DescriptionListWidget(class_669 client, int width, int height, int top, int bottom, int entryHeight, ModListScreen parent) {
		super(client, width, height, top, bottom, entryHeight);
		this.parent = parent;
		this.textRenderer = client.field_2588;
	}

	@Override
	public int method_2643() {
		return this.field_2992 - 10;
	}

	@Override
	protected int method_2646() {
		return this.field_2992 - 6 + field_2997;
	}

	@Override
	protected int method_2639() {
		return entries.size();
	}

	@Override
	public void method_2631(int mouseX, int mouseY, float delta) {
		ModListEntry selectedEntry = parent.getSelectedEntry();
		if (selectedEntry != lastSelected) {
			lastSelected = selectedEntry;
			entries.clear();
			field_3004 = -Float.MAX_VALUE;
			String description = lastSelected.getMetadata().getDescription();
			String id = lastSelected.getMetadata().getId();
			if (description.isEmpty() && HardcodedUtil.getHardcodedDescriptions().containsKey(id)) {
				description = HardcodedUtil.getHardcodedDescription(id);
			}
			if (lastSelected != null && description != null && !description.isEmpty()) {
				for (String line : textRenderer.method_2408(description.replaceAll("\n", "\n\n"), method_2643())) {
					entries.add(new DescriptionEntry(line));
				}
			}
		}
		super.method_2631(mouseX, mouseY, delta);
	}

	@Override
	protected void method_2645(int y1, int y2, int startAlpha, int endAlpha) {
		// Awful hack but it makes the background "seamless"
		ModListScreen.overlayBackground(field_2997, y1, field_2996, y2, 64, 64, 64, startAlpha, endAlpha);
	}

	@Override
	public class_699 method_2564(int index) {
		return entries.get(index);
	}

	protected static class DescriptionEntry implements class_698.class_699 {
		protected String text;

		public DescriptionEntry(String text) {
			this.text = text;
		}

		@Override
		public void method_2569(int index, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered) {
			class_669.method_2221().field_2588.method_2387(text, x, y, 0xAAAAAA);
		}

		@Override
		public boolean method_2568(int index, int mouseX, int mouseY, int button, int x, int y) {
			return false; // NO-OP
		}

		@Override
		public void method_2570(int index, int mouseX, int mouseY, int button, int x, int y) {
			// NO-OP
		}

		@Override
		public void method_2567(int index, int x, int y) {
			// NO-OP
		}
	}

}
