package io.github.prospector.modmenu.gui;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.util.BadgeRenderer;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1013;
import net.minecraft.class_1219;
import net.minecraft.class_1234;
import net.minecraft.class_1605;
import net.minecraft.class_669;
import net.minecraft.class_679;
import net.minecraft.class_681;
import net.minecraft.class_698;

public class ModListEntry implements class_698.class_699 {
	public static final class_1605 UNKNOWN_ICON = new class_1605("textures/misc/unknown_pack.png");
	private static final Logger LOGGER = LogManager.getLogger();

	protected final class_669 client;
	protected final ModContainer container;
	protected final ModMetadata metadata;
	protected final ModListWidget list;
	protected class_1605 iconLocation;
	protected boolean hovered;

	public ModListEntry(ModContainer container, ModListWidget list) {
		this.container = container;
		this.list = list;
		this.metadata = container.getMetadata();
		this.client = class_669.method_2221();
	}

	public void updateHovered(boolean hovered) {
		this.hovered = hovered;
	}

	@Override
	public void method_2567(int index, int x, int y) {
		// NO-OP
	}

	@Override
	public void method_2569(int index, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered) {
		updateHovered(hovered);
		x += getXOffset();
		rowWidth -= getXOffset();
		class_1013.method_3431(1.0F, 1.0F, 1.0F, 1.0F);
		this.bindIconTexture();
		class_1013.method_3449();
		class_681.method_2444(x, y, 0.0F, 0.0F, 32, 32, 32, 32);
		class_1013.method_3448();
		String name = HardcodedUtil.formatFabricModuleName(metadata.getName());
		String trimmedName = name;
		int maxNameWidth = rowWidth - 32 - 3;
		class_679 font = this.client.field_2588;
		if (font.method_2386(name) > maxNameWidth) {
			trimmedName = font.method_2389(name, maxNameWidth - font.method_2386("...")) + "...";
		}
		font.method_2390(trimmedName, x + 32 + 3, y + 1, 0xFFFFFF);
		new BadgeRenderer(x + 32 + 3 + font.method_2386(name) + 2, y, x + rowWidth, container, list.getParent()).draw(mouseX, mouseY);
		String description = metadata.getDescription();
		if (description.isEmpty() && HardcodedUtil.getHardcodedDescriptions().containsKey(metadata.getId())) {
			description = HardcodedUtil.getHardcodedDescription(metadata.getId());
		}
		RenderUtils.drawWrappedString(description, (x + 32 + 3 + 4), (y + client.field_2588.field_2815 + 2), rowWidth - 32 - 7, 2, 0x808080);
	}

	@Override
	public boolean method_2568(int index, int mouseX, int mouseY, int button, int x, int y) {
		if (hovered) {
			list.select(this);
			return true;
		}
		return false;
	}

	@Override
	public void method_2570(int index, int mouseX, int mouseY, int button, int x, int y) {
		// NO-OP
	}

	private class_1219 createIcon() {
		try {
			Path path = container.getPath(metadata.getIconPath(64 * class_669.method_2221().field_2597.field_2663).orElse("assets/" + metadata.getId() + "/icon.png"));
			class_1219 cached = this.list.getCachedModIcon(path);
			if (cached != null) {
				return cached;
			}
			if (!Files.exists(path)) {
				ModContainer modMenu = FabricLoader.getInstance().getModContainer(ModMenu.MOD_ID).orElseThrow(IllegalAccessError::new);
				if (HardcodedUtil.getFabricMods().contains(metadata.getId())) {
					path = modMenu.getPath("assets/" + ModMenu.MOD_ID + "/fabric_icon.png");
				} else if (metadata.getId().equals("minecraft")) {
					path = modMenu.getPath("assets/" + ModMenu.MOD_ID + "/mc_icon.png");
				} else {
					path = modMenu.getPath("assets/" + ModMenu.MOD_ID + "/grey_fabric_icon.png");
				}
			}
			cached = this.list.getCachedModIcon(path);
			if (cached != null) {
				return cached;
			}
			try (InputStream inputStream = Files.newInputStream(path)) {
				BufferedImage image = class_1234.method_4294(Objects.requireNonNull(inputStream));
				Validate.validState(image.getHeight() == image.getWidth(), "Must be square icon");
				class_1219 tex = new class_1219(image);
				this.list.cacheModIcon(path, tex);
				return tex;
			}

		} catch (Throwable t) {
			LOGGER.error("Invalid icon for mod {}", this.container.getMetadata().getName(), t);
			return null;
		}
	}

	public ModMetadata getMetadata() {
		return metadata;
	}

	public void bindIconTexture() {
		if (this.iconLocation == null) {
			this.iconLocation = new class_1605("modmenu", metadata.getId() + "_icon");
			class_1219 icon = this.createIcon();
			if (icon != null) {
				this.client.method_2236().method_4271(this.iconLocation, icon);
			} else {
				this.iconLocation = UNKNOWN_ICON;
			}
		}
		this.client.method_2236().method_4270(this.iconLocation);
	}

	public int getXOffset() {
		return 0;
	}
}
