package io.github.prospector.modmenu.gui;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.util.BadgeRenderer;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1002;
import net.minecraft.class_1013;
import net.minecraft.class_1041;
import net.minecraft.class_1239;
import net.minecraft.class_1268;
import net.minecraft.class_1480;
import net.minecraft.class_1605;
import net.minecraft.class_669;
import net.minecraft.class_681;
import net.minecraft.class_685;
import net.minecraft.class_689;
import net.minecraft.class_724;
import net.minecraft.class_754;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.*;

public class ModListScreen extends class_754 {
	private static final class_1605 FILTERS_BUTTON_LOCATION = new class_1605(ModMenu.MOD_ID, "textures/gui/filters_button.png");
	private static final class_1605 CONFIGURE_BUTTON_LOCATION = new class_1605(ModMenu.MOD_ID, "textures/gui/configure_button.png");
	private static final Logger LOGGER = LogManager.getLogger();
	private final String textTitle;
	private class_689 searchBox;
	private DescriptionListWidget descriptionListWidget;
	private final class_754 parent;
	private ModListWidget modList;
	private String tooltip;
	private ModListEntry selected;
	private BadgeRenderer badgeRenderer;
	private double scrollPercent = 0;
	private boolean showModCount = false;
	private boolean init = false;
	private boolean filterOptionsShown = false;
	private int paneY;
	private int paneWidth;
	private int rightPaneX;
	private int searchBoxX;
	public Set<String> showModChildren = new HashSet<>();

	public ModListScreen(class_754 parent) {
		super();
		this.parent = parent;
		this.textTitle = class_1268.method_4404("modmenu.title");
	}

	@Override
	public void method_2804() {
		this.searchBox.method_2511();
	}

	@Override
	public void method_2795() {
		Keyboard.enableRepeatEvents(true);
		paneY = 48;
		paneWidth = this.field_3209 / 2 - 8;
		rightPaneX = field_3209 - paneWidth;

		int searchBoxWidth = paneWidth - 32 - 22;
		searchBoxX = paneWidth / 2 - searchBoxWidth / 2 - 22 / 2;
		String oldText = Optional.ofNullable(searchBox).map(class_689::method_2521).orElse("");
		searchBox = new class_689(420, field_3214, searchBoxX, 22, searchBoxWidth, 20);
		searchBox.method_2519(oldText);
		modList = new ModListWidget(field_3207, paneWidth, field_3210, paneY + 19, field_3210 - 36, 36, searchBox.method_2521(), modList, this);
		modList.method_2651(0);
		descriptionListWidget = new DescriptionListWidget(field_3207, paneWidth, field_3210, paneY + 60, field_3210 - 36, field_3214.field_2815 + 1, this);
		descriptionListWidget.method_2651(rightPaneX);
		class_685 configureButton = new ModMenuTexturedButtonWidget(12341, field_3209 - 24, paneY, 20, 20, 0, 0, CONFIGURE_BUTTON_LOCATION, 32, 64,
				class_1268.method_4404("modmenu.configure")) {
			@Override
			public void method_2473(class_669 client, int mouseX, int mouseY) {
				if (field_2892) {
					setTooltip(class_1268.method_4404("modmenu.configure"));
				}
				if (selected != null) {
					String modid = selected.getMetadata().getId();
					field_2890 = ModMenu.hasFactory(modid) || ModMenu.hasLegacyConfigScreenTask(modid);
				} else {
					field_2890 = false;
				}
				field_2891 = field_2890;
				class_1013.method_3431(1, 1, 1, 1);
				super.method_2473(client, mouseX, mouseY);
			}
		};
		int urlButtonWidths = paneWidth / 2 - 2;
		int cappedButtonWidth = urlButtonWidths > 200 ? 200 : urlButtonWidths;
		class_685 websiteButton = new class_685(190, rightPaneX + (urlButtonWidths / 2) - (cappedButtonWidth / 2), paneY + 36, Math.min(urlButtonWidths, 200), 20,
				class_1268.method_4404("modmenu.website")) {
			@Override
			public void method_2473(class_669 client, int mouseX, int mouseY) {
				field_2891 = selected != null;
				field_2890 = field_2891 && selected.getMetadata().getContact().get("homepage").isPresent();
				super.method_2473(client, mouseX, mouseY);
			}
		};
		class_685 issuesButton = new class_685(191, rightPaneX + urlButtonWidths + 4 + (urlButtonWidths / 2) - (cappedButtonWidth / 2), paneY + 36, Math.min(urlButtonWidths, 200), 20,
				class_1268.method_4404("modmenu.issues")) {
			@Override
			public void method_2473(class_669 client, int mouseX, int mouseY) {
				field_2891 = selected != null;
				field_2890 = field_2891 && selected.getMetadata().getContact().get("issues").isPresent();
				super.method_2473(client, mouseX, mouseY);
			}
		};
		this.field_3211.add(new ModMenuTexturedButtonWidget(180, paneWidth / 2 + searchBoxWidth / 2 - 20 / 2 + 2, 22, 20, 20, 0, 0, FILTERS_BUTTON_LOCATION, 32, 64) {
			@Override
			public void method_2473(class_669 client, int mouseX, int mouseY) {
				super.method_2473(client, mouseX, mouseY);
				if (method_2470()) {
					setTooltip(class_1268.method_4404("modmenu.toggleFilterOptions"));
				}
			}
		});
		String showLibrariesText = class_1268.method_4404("modmenu.showLibraries", class_1268.method_4404("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries()));
		String sortingText = class_1268.method_4404("modmenu.sorting", class_1268.method_4404(ModMenuConfigManager.getConfig().getSorting().getTranslationKey()));
		int showLibrariesWidth = field_3214.method_2386(showLibrariesText) + 20;
		int sortingWidth = field_3214.method_2386(sortingText) + 20;
		int filtersX;
		int filtersWidth = showLibrariesWidth + sortingWidth + 2;
		if ((filtersWidth + field_3214.method_2386(class_1268.method_4404("modmenu.showingMods", NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size()))) + 20) >= searchBoxX + searchBoxWidth + 22) {
			filtersX = paneWidth / 2 - filtersWidth / 2;
			showModCount = false;
		} else {
			filtersX = searchBoxX + searchBoxWidth + 22 - filtersWidth + 1;
			showModCount = true;
		}
		this.field_3211.add(new class_685(181, filtersX, 45, sortingWidth, 20, sortingText) {
			@Override
			public void method_2473(class_669 client, int mouseX, int mouseY) {
				field_2891 = filterOptionsShown;
				field_2888 = (class_1268.method_4404("modmenu.sorting", class_1268.method_4404(ModMenuConfigManager.getConfig().getSorting().getTranslationKey())));
				super.method_2473(client, mouseY, mouseY);
			}
		});
		this.field_3211.add(new class_685(182, filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, class_1268.method_4404("modmenu.showLibraries", class_1268.method_4404("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries()))) {
			@Override
			public void method_2473(class_669 client, int mouseX, int mouseY) {
				field_2891 = filterOptionsShown;
				field_2888 = (class_1268.method_4404("modmenu.showLibraries", class_1268.method_4404("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries())));
				super.method_2473(client, mouseX, mouseY);
			}
		});
		this.field_3211.add(configureButton);
		this.field_3211.add(websiteButton);
		this.field_3211.add(issuesButton);
		this.field_3211.add(new class_685(201, this.field_3209 / 2 - 154, this.field_3210 - 28, 150, 20, class_1268.method_4404("modmenu.modsFolder")));
		this.field_3211.add(new class_685(202, this.field_3209 / 2 + 4, this.field_3210 - 28, 150, 20, class_1268.method_4404("gui.done")));

		init = true;
	}

	public ModListWidget getModList() {
		return modList;
	}

	protected void method_2787(class_685 button) {
 		if (button.field_2889 == 12341) {
		final String modid = Objects.requireNonNull(selected).getMetadata().getId();
		final class_754 screen = ModMenu.getConfigScreen(modid, this);
		if (screen != null) {
			field_3207.method_2253(screen);
		} else {
			ModMenu.openConfigScreen(modid);
		}
	} else if (button.field_2889 == 190) {
		final ModMetadata metadata = Objects.requireNonNull(selected).getMetadata();
		this.field_3207.method_2253(new class_724((bool, id) -> {
			if (bool) {
				try {
					Class<?> var3 = Class.forName("java.awt.Desktop");
					Object object = var3.getMethod("getDesktop").invoke(null);
					var3.getMethod("browse", URI.class).invoke(object, new URI(metadata.getContact().get("homepage").get()));
				} catch (Throwable var5) {
					LogManager.getLogger().error("Couldn't open link", var5);
				}
			}
			this.field_3207.method_2253(this);
		}, metadata.getContact().get("homepage").get(), -1, true));
	} else if (button.field_2889 == 191) {
		final ModMetadata metadata = Objects.requireNonNull(selected).getMetadata();
		this.field_3207.method_2253(new class_724((bool, id) -> {
			if (bool) {
				try {
					Class<?> var3 = Class.forName("java.awt.Desktop");
					Object object = var3.getMethod("getDesktop").invoke(null);
					var3.getMethod("browse", URI.class).invoke(object, new URI(metadata.getContact().get("issues").get()));
				} catch (Throwable var5) {
					LogManager.getLogger().error("Couldn't open link", var5);
				}
			}
			this.field_3207.method_2253(this);
		}, metadata.getContact().get("issues").get(), -1, true));
	} else if (button.field_2889 == 180) {
		filterOptionsShown = !filterOptionsShown;
	} else if (button.field_2889 == 181) {
		ModMenuConfigManager.getConfig().toggleSortMode();
		modList.reloadFilters();
	} else if (button.field_2889 == 182) {
		ModMenuConfigManager.getConfig().toggleShowLibraries();
		modList.reloadFilters();
	} else if (button.field_2889 == 201) {
		File file = new File(FabricLoader.getInstance().getGameDirectory(), "mods");
		String string = file.getAbsolutePath();
		if (class_1480.method_5419() == class_1480.class_1481.field_6137) {
			try {
				LogManager.getLogger().info(string);
				Runtime.getRuntime().exec(new String[]{"/usr/bin/open", string});
				return;
			} catch (IOException var9) {
				LogManager.getLogger().error("Couldn't open file", var9);
			}
		} else if (class_1480.method_5419() == class_1480.class_1481.field_6136) {
			String string2 = String.format("cmd.exe /C start \"Open file\" \"%s\"", string);

			try {
				Runtime.getRuntime().exec(string2);
				return;
			} catch (IOException var8) {
				LogManager.getLogger().error("Couldn't open file", var8);
			}
		}

		boolean bl = false;

		try {
			Class<?> var5 = Class.forName("java.awt.Desktop");
			Object object = var5.getMethod("getDesktop").invoke(null);
			var5.getMethod("browse", URI.class).invoke(object, file.toURI());
		} catch (Throwable var7) {
			LogManager.getLogger().error("Couldn't open link", var7);
			bl = true;
		}

		if (bl) {
			LogManager.getLogger().info("Opening via system class!");
			Sys.openURL("file://" + string);
		}
	} else if (button.field_2889 == 202) {
		field_3207.method_2253(parent);
	}
}

	@Override
	public void method_2810() {
		super.method_2810();
		modList.method_2656();
	}

	@Override
	public void method_2781(char character, int code) {
		if (searchBox.method_2512(character, code)) {
			modList.filter(searchBox.method_2521(), false);
		} else super.method_2781(character, code);
	}

	@Override
	protected void method_2784(int mouseX, int mouseY, int button) {
		if (modList.method_2565(mouseX, mouseY, button)) {
			return;
		}
		super.method_2784(mouseX, mouseY, button);
	}

	@Override
	public void method_2783(int mouseX, int mouseY, float delta) {
		ModListScreen.overlayBackground(paneWidth, 0, rightPaneX, field_3210, 64, 64, 64, 255, 255);
		this.tooltip = null;
		ModListEntry selectedEntry = selected;
		if (selectedEntry != null) {
			this.descriptionListWidget.method_2631(mouseX, mouseY, delta);
		}
		this.modList.method_2631(mouseX, mouseY, delta);
		this.searchBox.method_2537();
		class_1013.method_3448();
		this.method_2450(this.field_3214, this.textTitle, this.modList.getWidth() / 2, 8, 16777215);
		super.method_2783(mouseX, mouseY, delta);
		if (showModCount || !filterOptionsShown) {
			field_3214.method_2390(class_1268.method_4404("modmenu.showingMods", NumberFormat.getInstance().format(modList.getDisplayedCount()) + "/" + NumberFormat.getInstance().format(FabricLoader.getInstance().getAllMods().size())), searchBoxX, 52, 0xFFFFFF);
		}
		if (selectedEntry != null) {
			ModMetadata metadata = selectedEntry.getMetadata();
			int x = rightPaneX;
			class_1013.method_3431(1.0F, 1.0F, 1.0F, 1.0F);
			this.selected.bindIconTexture();
			class_1013.method_3449();
			method_2444(x, paneY, 0.0F, 0.0F, 32, 32, 32, 32);
			class_1013.method_3448();
			int lineSpacing = field_3214.field_2815 + 1;
			int imageOffset = 36;
			String name = metadata.getName();
			name = HardcodedUtil.formatFabricModuleName(name);
			String trimmedName = name;
			int maxNameWidth = this.field_3209 - (x + imageOffset);
			if (field_3214.method_2386(name) > maxNameWidth) {
				trimmedName = field_3214.method_2389(name, maxNameWidth - field_3214.method_2386("...")) + "...";
			}
			field_3214.method_2390(trimmedName, x + imageOffset, paneY + 1, 0xFFFFFF);
			if (mouseX > x + imageOffset && mouseY > paneY + 1 && mouseY < paneY + 1 + field_3214.field_2815 && mouseX < x + imageOffset + field_3214.method_2386(trimmedName)) {
				setTooltip(class_1268.method_4404("modmenu.modIdToolTip", metadata.getId()));
			}
			if (init || badgeRenderer == null || badgeRenderer.getMetadata() != metadata) {
				badgeRenderer = new BadgeRenderer(x + imageOffset + Objects.requireNonNull(this.field_3207).field_2588.method_2386(trimmedName) + 2, paneY, field_3209 - 28, selectedEntry.container, this);
				init = false;
			}
			badgeRenderer.draw(mouseX, mouseY);
			field_3214.method_2390("v" + metadata.getVersion().getFriendlyString(), x + imageOffset, paneY + 2 + lineSpacing, 0x808080);
			String authors;
			List<String> names = new ArrayList<>();

			metadata.getAuthors().stream()
				.filter(Objects::nonNull)
				.map(Person::getName)
				.filter(Objects::nonNull)
				.forEach(names::add);

			if (!names.isEmpty()) {
				if (names.size() > 1) {
					authors = Joiner.on(", ").join(names);
				} else {
					authors = names.get(0);
				}
				RenderUtils.drawWrappedString(class_1268.method_4404("modmenu.authorPrefix", authors), x + imageOffset, paneY + 2 + lineSpacing * 2, paneWidth - imageOffset - 4, 1, 0x808080);
			}
			if (this.tooltip != null) {
				this.method_2793(Lists.newArrayList(Splitter.on("\n").split(this.tooltip)), mouseX, mouseY);
			}
		}

	}

	public static void overlayBackground(int x1, int y1, int x2, int y2, int red, int green, int blue, int startAlpha, int endAlpha) {
		class_1041 tessellator = class_1041.method_3567();
		class_1002 buffer = tessellator.method_3569();
		Objects.requireNonNull(class_669.method_2221()).method_2236().method_4270(class_681.field_2866);
		class_1013.method_3431(1.0F, 1.0F, 1.0F, 1.0F);
		buffer.method_3312(7, class_1239.field_5174);
		buffer.method_3317(x1, y2, 0.0D).method_3303(x1 / 32.0D, y2 / 32.0D).method_3322(red, green, blue, endAlpha).method_3327();
		buffer.method_3317(x2, y2, 0.0D).method_3303(x2 / 32.0D, y2 / 32.0D).method_3322(red, green, blue, endAlpha).method_3327();
		buffer.method_3317(x2, y1, 0.0D).method_3303(x2 / 32.0D, y1 / 32.0D).method_3322(red, green, blue, startAlpha).method_3327();
		buffer.method_3317(x1, y1, 0.0D).method_3303(x1 / 32.0D, y1 / 32.0D).method_3322(red, green, blue, startAlpha).method_3327();
		tessellator.method_3568();
	}

	@Override
	public void method_2812() {
		super.method_2812();
		this.modList.close();
	}

	public void setTooltip(String tooltip) {
		this.tooltip = tooltip;
	}

	public ModListEntry getSelectedEntry() {
		return selected;
	}

	public void updateSelectedEntry(ModListEntry entry) {
		if (entry != null) {
			this.selected = entry;
		}
	}

	public double getScrollPercent() {
		return scrollPercent;
	}

	public void updateScrollPercent(double scrollPercent) {
		this.scrollPercent = scrollPercent;
	}

	public String getSearchInput() {
		return searchBox.method_2521();
	}

	public boolean showingFilterOptions() {
		return filterOptionsShown;
	}
}
