package io.github.prospector.modmenu.gui;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.gui.entries.ChildEntry;
import io.github.prospector.modmenu.gui.entries.IndependentEntry;
import io.github.prospector.modmenu.gui.entries.ParentEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1219;
import net.minecraft.class_1704;
import net.minecraft.class_669;
import net.minecraft.class_698;

public class ModListWidget extends class_698 implements AutoCloseable {
	private static final Logger LOGGER = LogManager.getLogger();
	public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");

	private final Map<Path, class_1219> modIconsCache = new HashMap<>();
	private final ModListScreen parent;
	private List<ModContainer> modContainerList = null;
	private Set<ModContainer> addedMods = new HashSet<>();
	private String selectedModId = null;
	private boolean scrolling;
	private List<ModListEntry> entries = new LinkedList<>();
	private ModListEntry selected = null;

	public ModListWidget(class_669 client, int width, int height, int y1, int y2, int entryHeight, String searchTerm, ModListWidget list, ModListScreen parent) {
		super(client, width, height, y1, y2, entryHeight);
		this.parent = parent;
		if (list != null) {
			this.modContainerList = list.modContainerList;
		}
		this.filter(searchTerm, false);
		setScrollAmount(parent.getScrollPercent() * Math.max(0, this.method_2652() - (this.field_2995 - this.field_2994 - 4)));
	}

	public void setScrollAmount(double amount) {
		field_3004 = (float) amount;
		method_2653();
		int denominator = Math.max(0, this.method_2652() - (this.field_2995 - this.field_2994 - 4));
		if (denominator <= 0) {
			parent.updateScrollPercent(0);
		} else {
			parent.updateScrollPercent(method_2655() / Math.max(0, this.method_2652() - (this.field_2995 - this.field_2994 - 4)));
		}
	}

	public void select(ModListEntry entry) {
		this.setSelected(entry);
		// TODO: narrator
//		if (entry != null) {
//			ModMetadata metadata = entry.getMetadata();
//			NarratorManager.INSTANCE.narrate(new TranslatableText("narrator.select", HardcodedUtil.formatFabricModuleName(metadata.getName())).getString());
//		}
	}

	public void setSelected(ModListEntry entry) {
		selected = entry;
		selectedModId = entry.getMetadata().getId();
		parent.updateSelectedEntry(selected);
	}

	@Override
	protected int method_2639() {
		return entries.size();
	}

	@Override
	protected boolean method_2629(int index) {
		return selected != null && selected.getMetadata().getId().equals(getEntry(index).getMetadata().getId());
	}

	@Override
	public ModListEntry getEntry(int index) {
		return entries.get(index);
	}

	public boolean addEntry(ModListEntry entry) {
		if (addedMods.contains(entry.container)) {
			return false;
		}
		addedMods.add(entry.container);
		boolean b = entries.add(entry);
		if (entry.getMetadata().getId().equals(selectedModId)) {
			setSelected(entry);
		}
		return b;
	}

	protected boolean removeEntry(ModListEntry entry) {
		addedMods.remove(entry.container);
		return entries.remove(entry);
	}

	protected ModListEntry remove(int index) {
		addedMods.remove(getEntry(index).container);
		return entries.remove(index);
	}

	public void reloadFilters() {
		filter(parent.getSearchInput(), true, false);
	}


	public void filter(String searchTerm, boolean refresh) {
		filter(searchTerm, refresh, true);
	}

	private void filter(String searchTerm, boolean refresh, boolean search) {
		entries.clear();
		addedMods.clear();
		Collection<ModContainer> mods = FabricLoader.getInstance().getAllMods();

		if (this.modContainerList == null || refresh) {
			this.modContainerList = new ArrayList<>();
			modContainerList.addAll(mods);
			this.modContainerList.sort(ModMenuConfigManager.getConfig().getSorting().getComparator());
		}

		boolean validSearch = ModListSearch.validSearchQuery(searchTerm);
		List<ModContainer> matched = ModListSearch.search(searchTerm, modContainerList);

		for (ModContainer container : matched) {
			ModMetadata metadata = container.getMetadata();
			String modId = metadata.getId();
			boolean library = ModMenu.LIBRARY_MODS.contains(modId);

			//Hide parent lib mods when not searching, and the config is set to hide
			if(!validSearch && library && !ModMenuConfigManager.getConfig().showLibraries()){
				continue;
			}

			if (!ModMenu.PARENT_MAP.values().contains(container)) {
				if (ModMenu.PARENT_MAP.keySet().contains(container)) {
					//A parent mod with children

					List<ModContainer> children = ModMenu.PARENT_MAP.get(container);
					children.sort(ModMenuConfigManager.getConfig().getSorting().getComparator());
					ParentEntry parent = new ParentEntry(container, children, this);
					this.addEntry(parent);

					//Add all the child mods when not searching
					if (!validSearch && this.parent.showModChildren.contains(modId)) {
						for (ModContainer child : children) {
							this.addEntry(new ChildEntry(child, parent, this, children.indexOf(child) == children.size() - 1));
						}
					}
				} else {
					//A mod with no children
					this.addEntry(new IndependentEntry(container, this));
				}
			} else if(validSearch) {
				//A child mod that came up when searching
				this.addEntry(new IndependentEntry(container, this));
			}
		}

		if (parent.getSelectedEntry() != null && !entries.isEmpty() || selected != null && selected.getMetadata() != parent.getSelectedEntry().getMetadata()) {
			for (ModListEntry entry : entries) {
				if (entry.getMetadata().equals(parent.getSelectedEntry().getMetadata())) {
					setSelected(entry);
				}
			}
		} else {
			if (selected == null && !entries.isEmpty() && getEntry(0) != null) {
				setSelected(getEntry(0));
			}
		}

		if (method_2655() > Math.max(0, this.method_2652() - (this.field_2995 - this.field_2994 - 4))) {
			setScrollAmount(Math.max(0, this.method_2652() - (this.field_2995 - this.field_2994 - 4)));
		}
	}

	public final ModListEntry getEntryAtPos(double x, double y) {
		int int_5 = class_1704.method_6647(y - (double) this.field_2994) - this.field_3010 + (int) this.method_2655() - 4;
		int index = int_5 / this.field_2998;
		return x < (double) this.method_2646() && x >= (double) getRowLeft() && x <= (double) (getRowLeft() + method_2643()) && index >= 0 && int_5 >= 0 && index < this.method_2639() ? entries.get(index) : null;
	}

	@Override
	protected int method_2646() {
		return this.field_2992 - 6;
	}

	@Override
	public int method_2643() {
		return this.field_2992 - (Math.max(0, this.method_2652() - (this.field_2995 - this.field_2994 - 4)) > 0 ? 18 : 12);
	}

//	@Override
	protected int getRowLeft() {
		return field_2994 + 6;
	}

	public int getWidth() {
		return field_2992;
	}

	public int getTop() {
		return this.field_2994;
	}

	public ModListScreen getParent() {
		return parent;
	}

	@Override
	protected int method_2652() {
		return super.method_2652() + 4;
	}

	public int getDisplayedCount() {
		return entries.size();
	}

	@Override
	public void close() {
		for (class_1219 tex : this.modIconsCache.values()) {
			tex.method_4194();
		}
	}

	class_1219 getCachedModIcon(Path path) {
		return this.modIconsCache.get(path);
	}

	void cacheModIcon(Path path, class_1219 tex) {
		this.modIconsCache.put(path, tex);
	}

	public Set<ModContainer> getCurrentModSet() {
		return addedMods;
	}
}
