package io.github.prospector.modmenu.gui.entries;

import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListWidget;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_681;

public class ChildEntry extends ModListEntry {
	private boolean bottomChild;
	private ParentEntry parent;

	public ChildEntry(ModContainer container, ParentEntry parent, ModListWidget list, boolean bottomChild) {
		super(container, list);
		this.bottomChild = bottomChild;
		this.parent = parent;
	}

	@Override
	public void method_2569(int index, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered) {
		super.method_2569(index, x, y, rowWidth, rowHeight, mouseX, mouseY, hovered);
		x += 4;
		int color = 0xFFA0A0A0;
		class_681.method_2447(x, y - 2, x + 1, y + (bottomChild ? rowHeight / 2 : rowHeight + 2), color);
		class_681.method_2447(x, y + rowHeight / 2, x + 7, y + rowHeight / 2 + 1, color);
	}

	@Override
	public int getXOffset() {
		return 13;
	}
}
