package io.github.prospector.modmenu.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_669;
import net.minecraft.class_681;
import java.util.List;

import io.github.prospector.modmenu.mixin.TextRendererAccessor;

@Environment(EnvType.CLIENT)
public class RenderUtils {
	private static final class_669 CLIENT = class_669.method_2221();

	public static void drawWrappedString(String string, int x, int y, int wrapWidth, int lines, int color) {
		while (string != null && string.endsWith("\n")) {
			string = string.substring(0, string.length() - 1);
		}
		List<String> strings = CLIENT.field_2588.method_2408(string, wrapWidth);
		for (int i = 0; i < strings.size(); i++) {
			if (i >= lines) {
				break;
			}
			String line = strings.get(i);
			if (i == lines - 1 && strings.size() > lines) {
				line += "...";
			}
			int x1 = x;
			if (CLIENT.field_2588.method_2397()) {
				int width = CLIENT.field_2588.method_2386(((TextRendererAccessor) CLIENT.field_2588).callMirror(line));
				x1 += (float) (wrapWidth - width);
			}
			CLIENT.field_2588.method_2390(line, x1, y + i * CLIENT.field_2588.field_2815, color);
		}
	}

	public static void drawBadge(int x, int y, int tagWidth, String text, int outlineColor, int fillColor, int textColor) {
		class_681.method_2447(x + 1, y - 1, x + tagWidth, y, outlineColor);
		class_681.method_2447(x, y, x + 1, y + CLIENT.field_2588.field_2815, outlineColor);
		class_681.method_2447(x + 1, y + 1 + CLIENT.field_2588.field_2815 - 1, x + tagWidth, y + CLIENT.field_2588.field_2815 + 1, outlineColor);
		class_681.method_2447(x + tagWidth, y, x + tagWidth + 1, y + CLIENT.field_2588.field_2815, outlineColor);
		class_681.method_2447(x + 1, y, x + tagWidth, y + CLIENT.field_2588.field_2815, fillColor);
		CLIENT.field_2588.method_2388(text, (x + 1 + (tagWidth - CLIENT.field_2588.method_2386(text)) / (float) 2), y + 1, textColor, false);
	}
}
