/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.potatounit;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.launch.knot.Knot;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public abstract class TestRunner
extends BlockJUnit4ClassRunner {
    protected final ClassLoader loader = this.getTestClass().getJavaClass().getClassLoader();

    public TestRunner(Class<?> testClass, EnvType type) throws InitializationError, ReflectiveOperationException {
        super(Class.forName(testClass.getName(), true, TestRunner.loader(type)));
    }

    protected static ClassLoader loader(EnvType type) throws ReflectiveOperationException {
        System.setProperty("fabric.dli.env", type.name().toLowerCase(Locale.ROOT));
        return TestRunner.main(new String[]{"nogui"});
    }

    public void run(RunNotifier notifier) {
        try {
            Thread thread = new Thread(() -> super.run(notifier));
            thread.setContextClassLoader(this.loader);
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassLoader main(String[] args) throws ReflectiveOperationException {
        String env = System.clearProperty("fabric.dli.env");
        String main = System.clearProperty("fabric.dli.main");
        String config = System.clearProperty("fabric.dli.config");
        if (main == null) {
            System.err.println("error: missing fabric.dli.main property, can't launch (copy your run args into the test run args)");
            System.exit(1);
        } else if (env == null || config == null) {
            TestRunner.warnNoop("missing fabric.dli.env or fabric.dli.config properties  (copy your run args into the test run args)");
        } else {
            Path configFile = Paths.get(TestRunner.decodeEscaped(config), new String[0]);
            if (!Files.isRegularFile(configFile, new LinkOption[0]) || !Files.isReadable(configFile)) {
                TestRunner.warnNoop("missing or unreadable config file (" + configFile + ")  (copy your run args into the test run args)");
            } else {
                ArrayList<String> extraArgs = new ArrayList<String>();
                HashMap<String, String> extraProperties = new HashMap<String, String>();
                try {
                    TestRunner.parseConfig(configFile, env, extraArgs, extraProperties);
                    String[] newArgs = extraArgs.toArray(new String[args.length + extraArgs.size()]);
                    System.arraycopy(args, 0, newArgs, extraArgs.size(), args.length);
                    args = newArgs;
                    for (Map.Entry e : extraProperties.entrySet()) {
                        System.setProperty((String)e.getKey(), (String)e.getValue());
                    }
                }
                catch (IOException e) {
                    TestRunner.warnNoop("parsing failed: " + e.toString());
                }
            }
        }
        if (main.equals("net.fabricmc.loader.launch.knot.KnotClient") || main.equals("net.fabricmc.loader.launch.knot.KnotServer")) {
            Knot knot = new Knot(EnvType.valueOf((String)env.toUpperCase(Locale.ROOT)), null);
            Method init = Knot.class.getDeclaredMethod("init", String[].class);
            init.setAccessible(true);
            return (ClassLoader)init.invoke((Object)knot, new Object[]{args});
        }
        throw new UnsupportedOperationException(main);
    }

    private static void parseConfig(Path file, String env, List<String> extraArgs, Map<String, String> extraProperties) throws IOException {
        boolean STATE_NONE = false;
        boolean STATE_ARGS = true;
        int STATE_PROPERTIES = 2;
        int STATE_SKIP = 3;
        try (BufferedReader reader = Files.newBufferedReader(file);){
            String line;
            int state = 0;
            while ((line = reader.readLine()) != null) {
                boolean indented;
                if (line.isEmpty()) continue;
                boolean bl = indented = line.charAt(0) == ' ' || line.charAt(0) == '\t';
                if ((line = line.trim()).isEmpty()) continue;
                if (!indented) {
                    int offset;
                    if (line.startsWith("common")) {
                        offset = "common".length();
                    } else if (line.startsWith(env)) {
                        offset = env.length();
                    } else {
                        state = 3;
                        continue;
                    }
                    switch (line.substring(offset)) {
                        case "Args": {
                            state = 1;
                            break;
                        }
                        case "Properties": {
                            state = 2;
                            break;
                        }
                        default: {
                            throw new IOException("invalid attribute: " + line);
                        }
                    }
                    continue;
                }
                if (state == 0) {
                    throw new IOException("value without preceding attribute: " + line);
                }
                if (state == 1) {
                    extraArgs.add(line);
                    continue;
                }
                if (state == 2) {
                    int pos = line.indexOf(61);
                    String key = pos >= 0 ? line.substring(0, pos).trim() : line;
                    String value = pos >= 0 ? line.substring(pos + 1).trim() : "";
                    extraProperties.put(key, value);
                    continue;
                }
                if (state == 3) continue;
                throw new IllegalStateException();
            }
        }
    }

    private static void warnNoop(String msg) {
        System.out.printf("warning: dev-launch-injector in pass-through mode, %s%n", msg);
    }

    private static String decodeEscaped(String s) {
        if (s.indexOf("@@") < 0) {
            return s;
        }
        Matcher matcher = Pattern.compile("@@([0-9a-fA-F]{1,4})").matcher(s);
        StringBuilder ret = new StringBuilder(s.length());
        int start = 0;
        while (matcher.find()) {
            ret.append(s, start, matcher.start());
            ret.append((char)Integer.parseInt(matcher.group(1), 16));
            start = matcher.end();
        }
        ret.append(s, start, s.length());
        return ret.toString();
    }

    public static final class Client
    extends TestRunner {
        public Client(Class<?> testClass) throws InitializationError, ReflectiveOperationException {
            super(testClass, EnvType.CLIENT);
        }
    }

    public static final class Server
    extends TestRunner {
        public Server(Class<?> testClass) throws InitializationError, ReflectiveOperationException {
            super(testClass, EnvType.SERVER);
        }
    }
}

