/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.armor;

import java.util.Random;
import net.fabricmc.fabric.api.armor.v1.ArmorMaterial;
import net.fabricmc.fabric.mixin.armor.MixinArmorItem;
import net.minecraft.class_2012;
import net.minecraft.class_2056;

public class FabricArmorItem extends class_2012 {
	private final ArmorMaterial material;
	private final int slotId;

	public FabricArmorItem(ArmorMaterial material, EquipmentSlot slot) {
		super(/*Can be anything but null*/class_2013.field_8541, new Random().nextInt(16777216), slot.getSlotId());
		this.material = material;
		this.slotId = slot.getSlotId();
		((MixinArmorItem) this).setProtection(material.getProtectionValue(slot.getSlotId()));
		this.method_8279(ArmorMaterial.BASE_DURABILITY[this.slotId] * material.getDurabilityMultiplier());
	}

	public ArmorMaterial getArmorMaterial() {
		return this.material;
	}

	public EquipmentSlot getEquipmentSlot() {
		return EquipmentSlot.getById(this.slotId);
	}

	@Override
	public int method_8269() {
		return this.material.getEnchantability();
	}

	@Override
	public int method_8292() {
		return 1;
	}

	public boolean method_8267(class_2056 stack, class_2056 ingredient) {
		return this.material.getRepairIngredient().test(ingredient);
	}

	@Deprecated
	@Override
	public int method_8257(class_2056 itemStack, int i) {
		return i;
	}

	@Deprecated
	@Override
	public int method_8169(class_2056 itemStack) {
		return 16777215;
	}

	@Deprecated
	@Override
	public void method_8171(class_2056 stack) {
	}

	@Deprecated
	@Override
	public void method_8170(class_2056 itemStack, int i) {
	}

	@Deprecated
	@Override
	public boolean method_8173(class_2056 stack) {
		return false;
	}
}
