/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.command;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.minecraft.class_1545;
import net.minecraft.class_1581;
import net.minecraft.class_1606;
import net.minecraft.server.MinecraftServer;
import net.fabricmc.fabric.api.command.CommandSide;
import net.fabricmc.fabric.api.event.server.FabricCommandRegisteredCallback;

@Mixin(class_1581.class)
public class MixinCommandRegistry {
	@Inject(method = "registerCommand", at = @At("TAIL"))
	public void afterRegister(class_1606 command, CallbackInfoReturnable<class_1606> cir) {
		if (command instanceof class_1545) {
			FabricCommandRegisteredCallback.EVENT.invoker().onCommandRegistered(MinecraftServer.method_6423(), (class_1545) command, CommandSide.COMMON);
		}
	}
}
