/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.command.v1;

import net.minecraft.class_1444;
import net.minecraft.class_1635;
import net.minecraft.class_1637;
import net.minecraft.class_1658;
import net.minecraft.class_1659;
import net.minecraft.class_1745;
import net.minecraft.class_649;

public class ServerCommandSource {
    private final class_1659 source;
    private final class_649 position;
    private final class_1635 world;
    private final class_1745 entity;
    private final int permissionLevel;

    public ServerCommandSource(class_1659 source, class_649 position, class_1635 world, class_1745 entity, int permissionLevel) {
        this.source = source;
        this.position = position;
        this.world = world;
        this.entity = entity;
        this.permissionLevel = permissionLevel;
    }

    public class_1659 getSource() {
        return this.source;
    }

    public class_649 getPosition() {
        return this.position;
    }

    public class_1635 getWorld() {
        return this.world;
    }

    public class_1745 getEntity() {
        return this.entity;
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public boolean isPlayer() {
        return this.entity instanceof class_1637;
    }

    public boolean hasPermissionLevel(int level) {
        return this.permissionLevel <= level;
    }

    public ServerCommandSource withPosition(class_649 position) {
        return new ServerCommandSource(this.source, position, this.world, this.entity, this.permissionLevel);
    }

    public ServerCommandSource withWorld(class_1635 world) {
        return new ServerCommandSource(this.source, this.position, world, this.entity, this.permissionLevel);
    }

    public ServerCommandSource withEntity(class_1745 entity) {
        return new ServerCommandSource(this.source, this.position, this.world, entity, this.permissionLevel);
    }

    public ServerCommandSource withPermission(int permissionLevel) {
        return new ServerCommandSource(this.source, this.position, this.world, this.entity, permissionLevel);
    }

    public void sendFeedback(class_1444 text) {
        if (this.source.method_6263()) {
            this.source.method_6256(text);
        }
    }

    public static ServerCommandSource from(class_1659 source) {
        int permissionLevel = 0;
        if (source.method_6262() instanceof class_1637) {
            class_1637 player = (class_1637)source.method_6262();
            class_1658 operatorEntry = (class_1658)player.field_6645.method_6480().method_6239().method_6273((Object)player.method_8022());
            if (operatorEntry != null) {
                permissionLevel = operatorEntry.method_6252();
            }
        }
        return new ServerCommandSource(source, source.method_6259(), (class_1635)source.method_6260(), source.method_6262(), permissionLevel);
    }
}

