/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.content.registry.v1;

import net.minecraft.class_1963;
import net.minecraft.class_2056;

@FunctionalInterface
public interface UseTickable {
	/**
	 * Called each tick when the item is being used.
	 * @param stack The {@link class_2056} being used
	 * @param player The {@link class_1963} using the item
	 * @param time The amount of time in ticks that the item is being used
	 */
	void useTick(class_2056 stack, class_1963 player, int time);
}
