/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.content.registries;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.content.registry.v1.FuelAccess;
import net.fabricmc.fabric.impl.content.registries.FuelRegistryImpl;
import net.minecraft.class_2056;
import net.minecraft.class_360;

@Mixin(class_360.class)
public class MixinFurnaceBlockEntity {
	@Inject(at = @At("HEAD"), method = "getBurnTime", cancellable = true)
	private static void registerFuels(class_2056 stack, CallbackInfoReturnable<Integer> info) {
		if (stack == null) return;

		if (stack.method_8353() instanceof FuelAccess) {
			info.setReturnValue(((FuelAccess) stack.method_8353()).getBurnTime(stack));
			return;
		}

		Integer value = FuelRegistryImpl.INSTANCE.getFuelMap().get(stack.method_8353());

		if (value != null) {
			info.setReturnValue(value);
		}
	}
}
