/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.content.registries;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.fabricmc.fabric.api.content.registry.v1.RarityProvider;
import net.minecraft.class_1405;
import net.minecraft.class_1444;
import net.minecraft.class_1454;
import net.minecraft.class_2054;
import net.minecraft.class_2056;

@Mixin(class_2056.class)
public abstract class MixinItemStack {
	@Shadow
	public abstract class_2054 getItem();

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/text/Style;setColor(Lnet/minecraft/util/Formatting;)Lnet/minecraft/text/Style;", shift = At.Shift.AFTER), method = "toHoverableText", locals = LocalCapture.CAPTURE_FAILSOFT)
	public void toHoverableTextHook(CallbackInfoReturnable<class_1444> cir, class_1454 literalText, class_1444 text, class_1405 compoundTag) {
		if (this.getItem() instanceof RarityProvider) {
			text.method_5162().method_5185(((RarityProvider) this.getItem()).getFormatting((class_2056) (Object) this));
		}
	}
}
