/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.content.registries;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.content.registry.v1.Climbable;
import net.minecraft.class_1372;
import net.minecraft.class_1704;
import net.minecraft.class_1745;
import net.minecraft.class_1752;
import net.minecraft.class_376;
import net.minecraft.class_99;

@Mixin(class_1752.class)
public abstract class MixinLivingEntity extends class_1745 {
	public MixinLivingEntity(class_99 world) {
		super(world);
	}

	@Inject(at = @At("RETURN"), method = "method_7166", cancellable = true)
	public void climb(CallbackInfoReturnable<Boolean> cir) {
		class_1372 pos = new class_1372(class_1704.method_6647(this.field_7398), class_1704.method_6647(this.method_6964().field_2408), class_1704.method_6647(this.field_7400));
		class_376 blockState = this.field_7394.method_483(pos);

		if (blockState.method_1227() instanceof Climbable) {
			cir.setReturnValue(((Climbable) blockState.method_1227()).canClimb(blockState, this.field_7394, pos, (class_1752) (Object) this));
		}
	}
}
