/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.content.registries;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import net.fabricmc.fabric.api.content.registry.v1.PlayerBlockHarvestListener;
import net.minecraft.class_1372;
import net.minecraft.class_1637;
import net.minecraft.class_1638;
import net.minecraft.class_99;

@Mixin(class_1638.class)
public class MixinServerPlayerInteractionManager {
	@Shadow
	public class_99 world;

	@Shadow
	public class_1637 player;

	@ModifyVariable(at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/server/network/ServerPlayerInteractionManager;method_6096(Lnet/minecraft/util/math/BlockPos;)Z"), method = "method_6094")
	public boolean modifyCanBreakBlock(boolean bl, class_1372 pos) {
		if (this.world.method_483(pos).method_1227() instanceof PlayerBlockHarvestListener) {
			return ((PlayerBlockHarvestListener) this.world.method_483(pos).method_1227()).canHarvest(this.world, pos, this.player);
		}

		return bl;
	}
}
