/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.content.registries;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.content.registries.ContentRegistryImpl;
import net.minecraft.class_1605;
import net.minecraft.class_1705;
import net.minecraft.class_411;
import net.minecraft.class_634;
import net.minecraft.class_635;
import net.minecraft.class_99;

@Mixin(class_99.class)
public class MixinWorld {
	@Shadow
	@Final
	public boolean isClient;

	@Inject(at = @At("RETURN"), method = "<init>")
	public void init(class_635 arg, class_634 levelProperties, class_411 dimension, class_1705 profiler, boolean client, CallbackInfo ci) {
		if (!isClient) {
			try {
				if (!ContentRegistryImpl.blockIdsSetup) {
					File blockIds = new File(arg.method_2013("blocks").getAbsoluteFile().getAbsolutePath().replace(".dat", ".registry"));
					blockIds.getParentFile().mkdirs();
					BiMap<Integer, class_1605> idMap = HashBiMap.create();
					this.readIdsFromFile(idMap, blockIds);

					ContentRegistryImpl.fillBlocksMapWithUnknownEntries(idMap);
					PrintWriter writer = new PrintWriter(new FileOutputStream(blockIds, false));

					for (Map.Entry<Integer, class_1605> entry : idMap.entrySet()) {
						writer.write(entry.getKey() + "\t" + entry.getValue().toString() + "\n");
					}

					writer.close();
					ContentRegistryImpl.reorderBlockEntries(idMap);
				}

				if (!ContentRegistryImpl.itemIdsSetup) {
					File itemIds = new File(arg.method_2013("items").getAbsoluteFile().getAbsolutePath().replace(".dat", ".registry"));
					itemIds.getParentFile().mkdirs();
					BiMap<Integer, class_1605> idMap = HashBiMap.create();
					this.readIdsFromFile(idMap, itemIds);

					ContentRegistryImpl.fillItemsMapWithUnknownEntries(idMap);
					PrintWriter writer = new PrintWriter(new FileOutputStream(itemIds, false));

					for (Map.Entry<Integer, class_1605> entry : idMap.entrySet()) {
						writer.write(entry.getKey() + "\t" + entry.getValue().toString() + "\n");
					}

					writer.close();
					ContentRegistryImpl.reorderItemEntries(idMap);
				}

				if (!ContentRegistryImpl.entityIdsSetup) {
					File entityIds = new File(arg.method_2013("entities").getAbsoluteFile().getAbsolutePath().replace(".dat", ".registry"));
					entityIds.getParentFile().mkdirs();
					BiMap<Integer, String> idMap = HashBiMap.create();
					this.readIdsFromFile(entityIds, idMap);

					ContentRegistryImpl.fillEntitiesMapWithUnknownEntries(idMap);
					PrintWriter writer = new PrintWriter(new FileOutputStream(entityIds, false));

					for (Map.Entry<Integer, String> entry : idMap.entrySet()) {
						writer.write(entry.getKey() + "\t" + entry.getValue().toString() + "\n");
					}

					writer.close();
					ContentRegistryImpl.reorderEntityEntries(idMap);
				}
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
	}

	@Unique
	private void readIdsFromFile(BiMap<Integer, class_1605> idMap, File file) throws IOException {
		if (file.exists()) {
			FileReader fileReader = new FileReader(file);
			BufferedReader bufferedReader = new BufferedReader(fileReader);
			String line;

			while ((line = bufferedReader.readLine()) != null) {
				if (line.isEmpty()) continue;
				int index = Integer.parseInt(line.substring(0, line.indexOf('\t')));
				String id = line.substring(line.indexOf('\t') + 1);
				idMap.put(index, new class_1605(id));
			}

			fileReader.close();
		}
	}

	@Unique
	private void readIdsFromFile(File file, BiMap<Integer, String> idMap) throws IOException {
		if (file.exists()) {
			FileReader fileReader = new FileReader(file);
			BufferedReader bufferedReader = new BufferedReader(fileReader);
			String line;

			while ((line = bufferedReader.readLine()) != null) {
				if (line.isEmpty()) continue;
				int index = Integer.parseInt(line.substring(0, line.indexOf('\t')));
				String id = line.substring(line.indexOf('\t') + 1);
				idMap.put(index, id);
			}

			fileReader.close();
		}
	}
}
