/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.registry.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_160;
import net.minecraft.class_1605;
import net.minecraft.class_1745;
import net.minecraft.class_2054;
import net.minecraft.class_348;

public final class FabricRegistryEntryAddedEvents {
    public static final Event<RegistryBlockAddedCallback> BLOCK = EventFactory.createArrayBacked(RegistryBlockAddedCallback.class, listeners -> (id, block) -> {
        for (RegistryBlockAddedCallback callback : listeners) {
            callback.blockAdded(id, block);
        }
    });
    public static final Event<RegistryBlockEntityAddedCallback> BLOCK_ENTITY = EventFactory.createArrayBacked(RegistryBlockEntityAddedCallback.class, listeners -> (blockEntityClass, name) -> {
        for (RegistryBlockEntityAddedCallback callback : listeners) {
            callback.blockEntityAdded(blockEntityClass, name);
        }
    });
    public static final Event<RegistryEntityAddedCallback> ENTITY = EventFactory.createArrayBacked(RegistryEntityAddedCallback.class, listeners -> (name, entityClass) -> {
        for (RegistryEntityAddedCallback callback : listeners) {
            callback.entityAdded(name, entityClass);
        }
    });
    public static final Event<RegistryItemAddedCallback> ITEM = EventFactory.createArrayBacked(RegistryItemAddedCallback.class, listeners -> (id, item) -> {
        for (RegistryItemAddedCallback callback : listeners) {
            callback.itemAdded(id, item);
        }
    });

    @FunctionalInterface
    public static interface RegistryItemAddedCallback {
        public void itemAdded(class_1605 var1, class_2054 var2);
    }

    @FunctionalInterface
    public static interface RegistryEntityAddedCallback {
        public void entityAdded(Class<? extends class_1745> var1, String var2);
    }

    @FunctionalInterface
    public static interface RegistryBlockEntityAddedCallback {
        public void blockEntityAdded(Class<? extends class_348> var1, String var2);
    }

    @FunctionalInterface
    public static interface RegistryBlockAddedCallback {
        public void blockAdded(class_1605 var1, class_160 var2);
    }
}

