/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.content.registries;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import net.fabricmc.fabric.impl.content.registries.ContentRegistryImpl;
import net.minecraft.class_1605;
import net.minecraft.class_1705;
import net.minecraft.class_411;
import net.minecraft.class_634;
import net.minecraft.class_635;
import net.minecraft.class_99;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_99.class})
public class MixinWorld {
    @Shadow
    @Final
    public boolean field_252;

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    public void init(class_635 arg, class_634 levelProperties, class_411 dimension, class_1705 profiler, boolean client, CallbackInfo ci) {
        if (!this.field_252) {
            try {
                PrintWriter writer;
                HashBiMap idMap;
                if (!ContentRegistryImpl.blockIdsSetup) {
                    File blockIds = new File(arg.method_2013("blocks").getAbsoluteFile().getAbsolutePath().replace(".dat", ".registry"));
                    blockIds.getParentFile().mkdirs();
                    idMap = HashBiMap.create();
                    this.readIdsFromFile((BiMap<Integer, class_1605>)idMap, blockIds);
                    ContentRegistryImpl.fillBlocksMapWithUnknownEntries((BiMap<Integer, class_1605>)idMap);
                    writer = new PrintWriter(new FileOutputStream(blockIds, false));
                    for (Map.Entry entry : idMap.entrySet()) {
                        writer.write(entry.getKey() + "\t" + ((class_1605)entry.getValue()).toString() + "\n");
                    }
                    writer.close();
                    ContentRegistryImpl.reorderBlockEntries((BiMap<Integer, class_1605>)idMap);
                }
                if (!ContentRegistryImpl.itemIdsSetup) {
                    File itemIds = new File(arg.method_2013("items").getAbsoluteFile().getAbsolutePath().replace(".dat", ".registry"));
                    itemIds.getParentFile().mkdirs();
                    idMap = HashBiMap.create();
                    this.readIdsFromFile((BiMap<Integer, class_1605>)idMap, itemIds);
                    ContentRegistryImpl.fillItemsMapWithUnknownEntries((BiMap<Integer, class_1605>)idMap);
                    writer = new PrintWriter(new FileOutputStream(itemIds, false));
                    for (Map.Entry entry : idMap.entrySet()) {
                        writer.write(entry.getKey() + "\t" + ((class_1605)entry.getValue()).toString() + "\n");
                    }
                    writer.close();
                    ContentRegistryImpl.reorderItemEntries((BiMap<Integer, class_1605>)idMap);
                }
                if (!ContentRegistryImpl.entityIdsSetup) {
                    File entityIds = new File(arg.method_2013("entities").getAbsoluteFile().getAbsolutePath().replace(".dat", ".registry"));
                    entityIds.getParentFile().mkdirs();
                    idMap = HashBiMap.create();
                    this.readIdsFromFile(entityIds, (BiMap<Integer, String>)idMap);
                    ContentRegistryImpl.fillEntitiesMapWithUnknownEntries((BiMap<Integer, String>)idMap);
                    writer = new PrintWriter(new FileOutputStream(entityIds, false));
                    for (Map.Entry entry : idMap.entrySet()) {
                        writer.write(entry.getKey() + "\t" + ((String)entry.getValue()).toString() + "\n");
                    }
                    writer.close();
                    ContentRegistryImpl.reorderEntityEntries((BiMap<Integer, String>)idMap);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Unique
    private void readIdsFromFile(BiMap<Integer, class_1605> idMap, File file) throws IOException {
        if (file.exists()) {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty()) continue;
                int index = Integer.parseInt(line.substring(0, line.indexOf(9)));
                String id = line.substring(line.indexOf(9) + 1);
                idMap.put((Object)index, (Object)new class_1605(id));
            }
            fileReader.close();
        }
    }

    @Unique
    private void readIdsFromFile(File file, BiMap<Integer, String> idMap) throws IOException {
        if (file.exists()) {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty()) continue;
                int index = Integer.parseInt(line.substring(0, line.indexOf(9)));
                String id = line.substring(line.indexOf(9) + 1);
                idMap.put((Object)index, (Object)id);
            }
            fileReader.close();
        }
    }
}

