/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.event.client.player;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_163;
import net.minecraft.class_1963;
import net.minecraft.class_2056;
import net.minecraft.class_647;

/**
 * This event is emitted during the block-picking process. It can be used to
 * modify the returned ItemStack, as well as nullify it - returning an empty
 * ItemStack will cause the event to leave, and no block to be picked.
 */
public interface ClientPickBlockApplyCallback {
	Event<ClientPickBlockApplyCallback> EVENT = EventFactory.createArrayBacked(ClientPickBlockApplyCallback.class,
			(listeners) -> (player, result, _stack) -> {
				class_2056 stack = _stack;

				for (ClientPickBlockApplyCallback event : listeners) {
					stack = event.pick(player, result, stack);

					if (stack.method_8374()) {
						return new class_2056(class_163.field_662);
					}
				}

				return stack;
			}
	);

	class_2056 pick(class_1963 player, class_647 result, class_2056 stack);
}
