/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.event.interaction;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.entity.EntityPickInteractionAware;
import net.fabricmc.fabric.api.event.client.player.ClientPickBlockGatherCallback;
import net.minecraft.class_1372;
import net.minecraft.class_163;
import net.minecraft.class_1745;
import net.minecraft.class_2056;
import net.minecraft.class_376;
import net.minecraft.class_647;

public class InteractionEventsRouterClient implements ClientModInitializer {
	@Override
	public void onInitializeClient() {
		ClientPickBlockGatherCallback.EVENT.register(((player, result) -> {
			if (result.field_2413 == class_647.class_648.field_2419) {
				class_1372 pos = result.method_2071();
				class_376 state = player.method_6260().method_483(pos);

				if (state.method_1227() instanceof BlockPickInteractionAware) {
					return (((BlockPickInteractionAware) state.method_1227()).getPickedStack(state, pos, player, result));
				}
			} else if (result.field_2413 == class_647.class_648.field_2420) {
				class_1745 entity = result.field_2416;

				if (entity instanceof EntityPickInteractionAware) {
					return ((EntityPickInteractionAware) entity).getPickedStack(player, result);
				}
			}

			return new class_2056(class_163.field_662);
		}));
	}
}
