/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.interaction;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.impl.base.util.ActionResult;
import net.fabricmc.fabric.impl.base.util.TypedActionResult;
import net.minecraft.class_102;
import net.minecraft.class_1372;
import net.minecraft.class_1383;
import net.minecraft.class_1400;
import net.minecraft.class_1561;
import net.minecraft.class_1745;
import net.minecraft.class_1963;
import net.minecraft.class_2056;
import net.minecraft.class_647;
import net.minecraft.class_649;
import net.minecraft.class_669;
import net.minecraft.class_903;
import net.minecraft.class_906;
import net.minecraft.class_99;

@Mixin(class_906.class)
@Environment(EnvType.CLIENT)
public class MixinClientPlayerInteractionManager {
	@Final
	@Shadow
	private class_669 client;
	@Final
	@Shadow
	private class_903 networkHandler;
	@Shadow
	private class_102.class_103 gameMode;

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/LevelInfo$GameMode;isCreative()Z", ordinal = 0), method = "attackBlock", cancellable = true)
	public void attackBlock(class_1372 pos, class_1383 direction, CallbackInfoReturnable<Boolean> info) {
		ActionResult result = AttackBlockCallback.EVENT.invoker().interact(client.field_2585, client.field_2583, pos, direction);

		if (result != ActionResult.PASS) {
			info.setReturnValue(result == ActionResult.SUCCESS);
			info.cancel();
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/LevelInfo$GameMode;isCreative()Z", ordinal = 0), method = "updateBlockBreakingProgress", cancellable = true)
	public void method_2902(class_1372 pos, class_1383 direction, CallbackInfoReturnable<Boolean> info) {
		if (!gameMode.method_475()) {
			return;
		}

		ActionResult result = AttackBlockCallback.EVENT.invoker().interact(client.field_2585, client.field_2583, pos, direction);

		if (result != ActionResult.PASS) {
			info.setReturnValue(result == ActionResult.SUCCESS);
			info.cancel();
		}
	}

	public void interactItem(class_1963 player, class_99 world, CallbackInfoReturnable<ActionResult> info) {
		TypedActionResult<class_2056> result = UseItemCallback.EVENT.invoker().interact(player, world);

		if (result.getResult() != ActionResult.PASS) {
			if (result.getResult() == ActionResult.SUCCESS) {
				return;
			}

			info.setReturnValue(result.getResult());
			info.cancel();
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayNetworkHandler;sendPacket(Lnet/minecraft/network/Packet;)V", ordinal = 0), method = "attackEntity", cancellable = true)
	public void attackEntity(class_1963 player, class_1745 entity, CallbackInfo info) {
		ActionResult result = AttackEntityCallback.EVENT.invoker().attack(player, player.method_6260() /* TODO */, entity, null);

		if (result != ActionResult.PASS) {
			if (result == ActionResult.SUCCESS) {
				this.networkHandler.method_3113(new class_1561());
			}

			info.cancel();
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayNetworkHandler;sendPacket(Lnet/minecraft/network/Packet;)V", ordinal = 0), method = "interactEntityAtLocation", cancellable = true)
	public void interactEntityAtLocation(class_1963 player, class_1745 entity, class_647 hitResult, CallbackInfoReturnable<Boolean> info) {
		ActionResult result = UseEntityCallback.EVENT.invoker().interact(player, player.method_6260(), entity, hitResult);

		if (result != ActionResult.PASS) {
			if (result == ActionResult.SUCCESS) {
				class_1372 hitVec = hitResult.method_2071().method_4875(new class_1400(entity.field_7398, entity.field_7399, entity.field_7400));
				this.networkHandler.method_3113(new class_1561(entity, new class_649(hitVec.method_4978(), hitVec.method_4979(), hitVec.method_4980())));
			}

			info.setReturnValue(result.isAccepted());
			info.cancel();
		}
	}
}
