/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.interaction;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.BreakBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.impl.base.util.ActionResult;
import net.fabricmc.fabric.impl.base.util.TypedActionResult;
import net.minecraft.class_1372;
import net.minecraft.class_1383;
import net.minecraft.class_1474;
import net.minecraft.class_1637;
import net.minecraft.class_1638;
import net.minecraft.class_1963;
import net.minecraft.class_2056;
import net.minecraft.class_647;
import net.minecraft.class_649;
import net.minecraft.class_99;

@Mixin(class_1638.class)
public class MixinServerPlayerInteractionManager {
	@Shadow
	public class_1637 player;

	@Shadow
	public class_99 world;

	@Inject(at = @At("HEAD"), method = "processBlockBreakingAction", cancellable = true)
	public void startBlockBreak(class_1372 pos, class_1383 direction, CallbackInfo info) {
		ActionResult result = AttackBlockCallback.EVENT.invoker().interact(player, world, pos, direction);

		if (result != ActionResult.PASS) {
			// The client might have broken the block on its side, so make sure to let it know.
			this.player.field_6639.method_6127(new class_1474(world, pos));
			info.cancel();
		}
	}

	@Inject(at = @At("HEAD"), method = "method_6091", cancellable = true)
	public void interactBlock(class_1963 playerEntity, class_99 world, class_2056 itemStack, class_1372 blockPos, class_1383 direction, float f, float g, float h, CallbackInfoReturnable<ActionResult> info) {
		ActionResult result = UseBlockCallback.EVENT.invoker().interact(player, world, new class_647(class_647.class_648.field_2418, new class_649(blockPos.method_4978(), blockPos.method_4979(), blockPos.method_4980()), direction, blockPos));

		if (result != ActionResult.PASS) {
			info.setReturnValue(result);
			info.cancel();
		}
	}

	@Inject(at = @At("HEAD"), method = "method_6090", cancellable = true)
	public void interactItem(class_1963 player, class_99 world, class_2056 stack, CallbackInfoReturnable<ActionResult> info) {
		TypedActionResult<class_2056> result = UseItemCallback.EVENT.invoker().interact(player, world);

		if (result.getResult() != ActionResult.PASS) {
			info.setReturnValue(result.getResult());
			info.cancel();
		}
	}

	@Inject(at = @At("HEAD"), method = "method_6096", cancellable = true)
	public void breakBlock(class_1372 blockPos, CallbackInfoReturnable<Boolean> info) {
		ActionResult result = BreakBlockCallback.EVENT.invoker().blockBreak(this.player, this.world, blockPos);

		if (result == ActionResult.FAIL) {
			info.setReturnValue(false);
		}
	}
}
