/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.itemgroup;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.item.group.ItemGroupExtensions;
import net.minecraft.class_1605;
import net.minecraft.class_2029;
import net.minecraft.class_2054;
import net.minecraft.class_2056;

public class FabricItemGroupBuilder {
	private final class_1605 identifier;
	private Supplier<class_2056> stackSupplier = () -> new class_2056((class_2054) null);
	private Consumer<List<class_2056>> stacksForDisplay;

	private FabricItemGroupBuilder(class_1605 identifier) {
		this.identifier = identifier;
	}

	public static FabricItemGroupBuilder create(class_1605 identifier) {
		return new FabricItemGroupBuilder(identifier);
	}

	public FabricItemGroupBuilder icon(Supplier<class_2056> stackSupplier) {
		this.stackSupplier = stackSupplier;
		return this;
	}

	public FabricItemGroupBuilder appendItems(Consumer<List<class_2056>> stacksForDisplay) {
		this.stacksForDisplay = stacksForDisplay;
		return this;
	}

	public static class_2029 build(class_1605 identifier, Supplier<class_2056> iconSupplier) {
		return new FabricItemGroupBuilder(identifier).icon(iconSupplier).build();
	}

	public class_2029 build() {
		((ItemGroupExtensions) class_2029.field_8553).fabric_expandArray();
		return new class_2029(class_2029.field_8552.length - 1, String.format("%s.%s", identifier.method_5883(), identifier.method_5881())) {
			private class_2056 cachedStack;

			@Override
			public class_2056 method_8197() {
				if (cachedStack != null) {
					return cachedStack;
				}

				return cachedStack = stackSupplier.get();
			}

			@Override
			public class_2054 method_8198() {
				return method_8197().method_8353();
			}

			@Override
			public int method_8199() {
				return this.method_8197().method_8376();
			}

			@Environment(EnvType.CLIENT)
			@Override
			public void method_8192(List<class_2056> list) {
				if (stacksForDisplay != null) {
					stacksForDisplay.accept(list);
					return;
				}

				super.method_8192(list);
			}
		};
	}
}
