/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.item.group;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.mixin.item.group.client.MixinScreen;
import net.minecraft.class_1013;
import net.minecraft.class_1455;
import net.minecraft.class_1605;
import net.minecraft.class_2029;
import net.minecraft.class_669;
import net.minecraft.class_685;
import net.minecraft.class_795;

public class FabricCreativeGuiComponents {
	private static final class_1605 BUTTON_TEX = new class_1605("fabric", "textures/gui/creative_buttons.png");
	public static final Set<class_2029> COMMON_GROUPS = new HashSet<>();

	static {
		COMMON_GROUPS.add(class_2029.field_8558);
		COMMON_GROUPS.add(class_2029.field_8564);
	}

	public static class ItemGroupButtonWidget extends class_685 {
		CreativeInventoryScreenExtensions extensions;
		class_795 gui;
		public Type type;

		public ItemGroupButtonWidget(int id, int x, int y, Type type, CreativeInventoryScreenExtensions extensions) {
			super(id, x, y, 11, 10, type.text);
			this.extensions = extensions;
			this.type = type;
			this.gui = (class_795) extensions;
		}

		@Override
		public void method_2473(class_669 client, int mouseX, int mouseY) {
			this.field_2892 = mouseX >= this.field_2886 && mouseY >= this.field_2887 && mouseX < this.field_2886 + this.field_2884 && mouseY < this.field_2887 + this.field_2885;
			this.field_2891 = extensions.fabric_isButtonVisible(type);
			this.field_2890 = extensions.fabric_isButtonEnabled(type);

			if (this.field_2891) {
				int u = field_2890 && this.method_2470() ? 22 : 0;
				int v = field_2890 ? 0 : 10;

				class_669 minecraftClient = class_669.method_2221();
				minecraftClient.method_2236().method_4270(BUTTON_TEX);
				class_1013.method_3438();
				class_1013.method_3431(1F, 1F, 1F, 1F);
				this.method_2452(this.field_2886, this.field_2887, u + (type == Type.NEXT ? 11 : 0), v, 11, 10);

				if (this.field_2892) {
					((MixinScreen) gui).invokeRenderTooltip(new class_1455("fabric.gui.creativeTabPage", extensions.fabric_currentPage() + 1, ((class_2029.field_8552.length - 12) / 9) + 2).method_5165(), mouseX, mouseY);
				}
			}
		}

		@Override
		public void method_2472(int mouseX, int mouseY) {
			super.method_2472(mouseX, mouseY);
		}
	}

	public enum Type {
		NEXT(">", CreativeInventoryScreenExtensions::fabric_nextPage),
		PREVIOUS("<", CreativeInventoryScreenExtensions::fabric_previousPage);

		String text;
		public Consumer<CreativeInventoryScreenExtensions> clickConsumer;

		Type(String text, Consumer<CreativeInventoryScreenExtensions> clickConsumer) {
			this.text = text;
			this.clickConsumer = clickConsumer;
		}
	}
}
