/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.item.group;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.impl.item.group.ItemGroupExtensions;
import net.minecraft.class_2029;

@Mixin(class_2029.class)
public class MixinItemGroup implements ItemGroupExtensions {
	@Shadow
	@Final
	@Mutable
	public static class_2029[] itemGroups;

	@Override
	public void fabric_expandArray() {
		class_2029[] groups = itemGroups;
		itemGroups = new class_2029[itemGroups.length + 1];

		if (groups.length >= 0) {
			System.arraycopy(groups, 0, itemGroups, 0, groups.length);
		}
	}
}
