/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.item.group.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.item.group.CreativeInventoryScreenExtensions;
import net.fabricmc.fabric.impl.item.group.FabricCreativeGuiComponents;
import net.minecraft.class_1983;
import net.minecraft.class_2029;
import net.minecraft.class_685;
import net.minecraft.class_795;
import net.minecraft.class_799;

@Environment(EnvType.CLIENT)
@Mixin(class_795.class)
public abstract class MixinCreativeInventoryScreen extends class_799 implements CreativeInventoryScreenExtensions {
	@Shadow
	protected abstract void setSelectedTab(class_2029 group);

	@Shadow
	public abstract int getSelectedTab();

	@Unique
	private static int fabric_currentPage = 0;

	public MixinCreativeInventoryScreen(class_1983 container) {
		super(container);
	}

	@Unique
	private int getPageOffset(int page) {
		switch (page) {
		case 0:
			return 0;
		case 1:
			return 12;
		default:
			return 12 + ((12 - FabricCreativeGuiComponents.COMMON_GROUPS.size()) * (page - 1));
		}
	}

	@Unique
	private int getOffsetPage(int offset) {
		if (offset < 12) {
			return 0;
		} else {
			return 1 + ((offset - 12) / (12 - FabricCreativeGuiComponents.COMMON_GROUPS.size()));
		}
	}

	@Unique
	private void updateSelection() {
		int minPos = this.getPageOffset(fabric_currentPage);
		int maxPos = this.getPageOffset(fabric_currentPage + 1) - 1;
		int curPos = getSelectedTab();

		if (curPos < minPos || curPos > maxPos) {
			setSelectedTab(class_2029.field_8552[this.getPageOffset(fabric_currentPage)]);
		}
	}

	@Unique
	private boolean fabric_isGroupNotVisible(class_2029 itemGroup) {
		if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
			return false;
		}

		return fabric_currentPage != this.getOffsetPage(itemGroup.method_8189());
	}

	@Override
	public void fabric_nextPage() {
		if (this.getPageOffset(fabric_currentPage + 1) >= class_2029.field_8552.length) {
			return;
		}

		fabric_currentPage++;
		updateSelection();
	}

	@Override
	public void fabric_previousPage() {
		if (fabric_currentPage == 0) {
			return;
		}

		fabric_currentPage--;
		updateSelection();
	}

	@Override
	public int fabric_currentPage() {
		return fabric_currentPage;
	}

	@Override
	public boolean fabric_isButtonVisible(FabricCreativeGuiComponents.Type type) {
		return class_2029.field_8552.length > 12;
	}

	@Override
	public boolean fabric_isButtonEnabled(FabricCreativeGuiComponents.Type type) {
		if (type == FabricCreativeGuiComponents.Type.NEXT) {
			return !(this.getPageOffset(fabric_currentPage + 1) >= class_2029.field_8552.length);
		}

		if (type == FabricCreativeGuiComponents.Type.PREVIOUS) {
			return fabric_currentPage != 0;
		}

		return false;
	}

	@Inject(method = "init", at = @At("RETURN"))
	private void init(CallbackInfo info) {
		this.updateSelection();

		int xPos = field_3394 + 116;
		int yPos = field_3395 - 10;

		this.field_3211.add(new FabricCreativeGuiComponents.ItemGroupButtonWidget(50, xPos + 39, yPos, FabricCreativeGuiComponents.Type.NEXT, this));
		this.field_3211.add(new FabricCreativeGuiComponents.ItemGroupButtonWidget(51, xPos + 29, yPos, FabricCreativeGuiComponents.Type.PREVIOUS, this));
	}

	@Inject(method = "buttonClicked", at = @At("HEAD"), cancellable = true)
	public void creativeButtonClicked(class_685 button, CallbackInfo ci) {
		if (button.field_2889 == 50) {
			fabric_nextPage();
			ci.cancel();
		}

		if (button.field_2889 == 51) {
			fabric_previousPage();
			ci.cancel();
		}
	}

	@Inject(method = "setSelectedTab", at = @At("HEAD"), cancellable = true)
	private void setSelectedTab(class_2029 itemGroup, CallbackInfo info) {
		if (this.fabric_isGroupNotVisible(itemGroup)) {
			info.cancel();
		}
	}

	@Inject(method = "renderTabTooltipIfHovered", at = @At("HEAD"), cancellable = true)
	private void renderTabTooltipIfHovered(class_2029 itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
		if (fabric_isGroupNotVisible(itemGroup)) {
			info.setReturnValue(false);
		}
	}

	@Inject(method = "method_2928", at = @At("HEAD"), cancellable = true)
	private void isMouseHovered(class_2029 itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
		if (fabric_isGroupNotVisible(itemGroup)) {
			info.setReturnValue(false);
		}
	}

	@Inject(method = "renderTabIcon", at = @At("HEAD"), cancellable = true)
	private void renderTabIcon(class_2029 itemGroup, CallbackInfo info) {
		if (fabric_isGroupNotVisible(itemGroup)) {
			info.cancel();
		}
	}
}
