/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.item.group.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.item.group.CreativeInventoryScreenExtensions;
import net.fabricmc.fabric.impl.item.group.FabricCreativeGuiComponents;
import net.minecraft.class_1983;
import net.minecraft.class_2029;
import net.minecraft.class_685;
import net.minecraft.class_795;
import net.minecraft.class_799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_795.class})
public abstract class MixinCreativeInventoryScreen
extends class_799
implements CreativeInventoryScreenExtensions {
    @Unique
    private static int fabric_currentPage = 0;

    @Shadow
    protected abstract void method_2929(class_2029 var1);

    @Shadow
    public abstract int method_2931();

    public MixinCreativeInventoryScreen(class_1983 container) {
        super(container);
    }

    @Unique
    private int getPageOffset(int page) {
        switch (page) {
            case 0: {
                return 0;
            }
            case 1: {
                return 12;
            }
        }
        return 12 + (12 - FabricCreativeGuiComponents.COMMON_GROUPS.size()) * (page - 1);
    }

    @Unique
    private int getOffsetPage(int offset) {
        if (offset < 12) {
            return 0;
        }
        return 1 + (offset - 12) / (12 - FabricCreativeGuiComponents.COMMON_GROUPS.size());
    }

    @Unique
    private void updateSelection() {
        int minPos = this.getPageOffset(fabric_currentPage);
        int maxPos = this.getPageOffset(fabric_currentPage + 1) - 1;
        int curPos = this.method_2931();
        if (curPos < minPos || curPos > maxPos) {
            this.method_2929(class_2029.field_8552[this.getPageOffset(fabric_currentPage)]);
        }
    }

    @Unique
    private boolean fabric_isGroupNotVisible(class_2029 itemGroup) {
        if (FabricCreativeGuiComponents.COMMON_GROUPS.contains(itemGroup)) {
            return false;
        }
        return fabric_currentPage != this.getOffsetPage(itemGroup.method_8189());
    }

    @Override
    public void fabric_nextPage() {
        if (this.getPageOffset(fabric_currentPage + 1) >= class_2029.field_8552.length) {
            return;
        }
        ++fabric_currentPage;
        this.updateSelection();
    }

    @Override
    public void fabric_previousPage() {
        if (fabric_currentPage == 0) {
            return;
        }
        --fabric_currentPage;
        this.updateSelection();
    }

    @Override
    public int fabric_currentPage() {
        return fabric_currentPage;
    }

    @Override
    public boolean fabric_isButtonVisible(FabricCreativeGuiComponents.Type type) {
        return class_2029.field_8552.length > 12;
    }

    @Override
    public boolean fabric_isButtonEnabled(FabricCreativeGuiComponents.Type type) {
        if (type == FabricCreativeGuiComponents.Type.NEXT) {
            return this.getPageOffset(fabric_currentPage + 1) < class_2029.field_8552.length;
        }
        if (type == FabricCreativeGuiComponents.Type.PREVIOUS) {
            return fabric_currentPage != 0;
        }
        return false;
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void init(CallbackInfo info) {
        this.updateSelection();
        int xPos = this.field_3394 + 116;
        int yPos = this.field_3395 - 10;
        this.field_3211.add(new FabricCreativeGuiComponents.ItemGroupButtonWidget(50, xPos + 39, yPos, FabricCreativeGuiComponents.Type.NEXT, this));
        this.field_3211.add(new FabricCreativeGuiComponents.ItemGroupButtonWidget(51, xPos + 29, yPos, FabricCreativeGuiComponents.Type.PREVIOUS, this));
    }

    @Inject(method={"buttonClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void creativeButtonClicked(class_685 button, CallbackInfo ci) {
        if (button.field_2889 == 50) {
            this.fabric_nextPage();
            ci.cancel();
        }
        if (button.field_2889 == 51) {
            this.fabric_previousPage();
            ci.cancel();
        }
    }

    @Inject(method={"setSelectedTab"}, at={@At(value="HEAD")}, cancellable=true)
    private void setSelectedTab(class_2029 itemGroup, CallbackInfo info) {
        if (this.fabric_isGroupNotVisible(itemGroup)) {
            info.cancel();
        }
    }

    @Inject(method={"renderTabTooltipIfHovered"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabTooltipIfHovered(class_2029 itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
        if (this.fabric_isGroupNotVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"method_2928"}, at={@At(value="HEAD")}, cancellable=true)
    private void isMouseHovered(class_2029 itemGroup, int mx, int my, CallbackInfoReturnable<Boolean> info) {
        if (this.fabric_isGroupNotVisible(itemGroup)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"renderTabIcon"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderTabIcon(class_2029 itemGroup, CallbackInfo info) {
        if (this.fabric_isGroupNotVisible(itemGroup)) {
            info.cancel();
        }
    }
}

