/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.keybinding;

import java.util.List;
import net.minecraft.class_666;
import com.google.common.collect.Lists;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class KeyBindingRegistryImpl {
	private static final Logger LOGGER = LogManager.getLogger();

	private static final List<class_666> moddedKeyBindings = Lists.newArrayList();

	private KeyBindingRegistryImpl() {
	}

	public static class_666 registerKeyBinding(class_666 binding) {
		for (class_666 existingKeyBindings : moddedKeyBindings) {
			if (existingKeyBindings == binding) {
				throw null;
			} else if (existingKeyBindings.method_2206().equals(binding.method_2206())) {
				throw new RuntimeException("Attempted to register two key bindings with equal ID: " + binding.method_2206() + "!");
			}
		}

		return moddedKeyBindings.add(binding) ? binding : null;
	}

	/**
	 * Processes the keybindings array for our modded ones by first removing existing modded keybindings and readding them,
	 * we can make sure that there are no duplicates this way.
	 */
	public static class_666[] process(class_666[] keysAll) {
		List<class_666> newKeysAll = Lists.newArrayList(keysAll);
		newKeysAll.removeAll(moddedKeyBindings);
		newKeysAll.addAll(moddedKeyBindings);
		return newKeysAll.toArray(new class_666[0]);
	}
}
