/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.client.event.lifecycle.v1;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1705;
import net.minecraft.class_1745;
import net.minecraft.class_907;

@Environment(EnvType.CLIENT)
public final class ClientEntityEvents {
	public ClientEntityEvents() {
	}

	/**
	 * Called when an Entity is loaded into a ClientWorld.
	 *
	 * <p>When this event is called, the chunk is already in the world.
	 */
	public static final Event<Load> ENTITY_LOAD = EventFactory.createArrayBacked(Load.class, callbacks -> (entity, world) -> {
		if (EventFactory.isProfilingEnabled()) {
			final class_1705 profiler = world.field_250;
			profiler.method_6668("fabricClientEntityLoad");

			for (Load callback : callbacks) {
				profiler.method_6668(EventFactory.getHandlerName(callback));
				callback.onLoad(entity, world);
				profiler.method_6669();
			}

			profiler.method_6669();
		} else {
			for (Load callback : callbacks) {
				callback.onLoad(entity, world);
			}
		}
	});

	/**
	 * Called when an Entity is about to be unloaded from a ClientWorld.
	 *
	 * <p>When this event is called, the entity is still present in the world.
	 */
	public static final Event<Unload> ENTITY_UNLOAD = EventFactory.createArrayBacked(Unload.class, callbacks -> (entity, world) -> {
		if (EventFactory.isProfilingEnabled()) {
			final class_1705 profiler = world.field_250;
			profiler.method_6668("fabricClientEntityLoad");

			for (Unload callback : callbacks) {
				profiler.method_6668(EventFactory.getHandlerName(callback));
				callback.onUnload(entity, world);
				profiler.method_6669();
			}

			profiler.method_6669();
		} else {
			for (Unload callback : callbacks) {
				callback.onUnload(entity, world);
			}
		}
	});

	@FunctionalInterface
	public interface Load {
		void onLoad(class_1745 entity, class_907 world);
	}

	@FunctionalInterface
	public interface Unload {
		void onUnload(class_1745 entity, class_907 world);
	}
}
