/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.event.lifecycle.client;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_102;
import net.minecraft.class_1315;
import net.minecraft.class_669;

@Environment(EnvType.CLIENT)
@Mixin(class_1315.class)
public class MixinIntegratedServer {
	@Shadow
	@Final
	private class_669 client;

	@Shadow
	@Final
	private class_102 levelInfo;

	@Inject(method = "method_6437", at = @At("HEAD"))
	public void publishToLan(class_102.class_103 gameMode, boolean cheats, CallbackInfoReturnable<String> info) {
		ClientLifecycleEvents.SERVER_PUBLISHED.invoker().onServerPublished(this.client, gameMode, cheats, this.levelInfo);
	}
}
