/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.event.lifecycle.v1;

import com.google.common.annotations.Beta;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_102;
import net.minecraft.class_669;
import net.minecraft.class_671;

@Environment(value=EnvType.CLIENT)
public final class ClientLifecycleEvents {
    public static final Event<ClientStarted> CLIENT_STARTED = EventFactory.createArrayBacked(ClientStarted.class, callbacks -> client -> {
        for (ClientStarted callback : callbacks) {
            callback.onClientStarted(client);
        }
    });
    public static final Event<ClientStopping> CLIENT_STOPPING = EventFactory.createArrayBacked(ClientStopping.class, callbacks -> client -> {
        for (ClientStopping callback : callbacks) {
            callback.onClientStopping(client);
        }
    });
    @Beta
    public static final Event<OutOfMemory> OUT_OF_MEMORY = EventFactory.createArrayBacked(OutOfMemory.class, listeners -> client -> {
        for (OutOfMemory event : listeners) {
            event.onOutOfMemoryError(client);
        }
    });
    public static final Event<IntegratedServerPublished> SERVER_PUBLISHED = EventFactory.createArrayBacked(IntegratedServerPublished.class, listeners -> (client, gameMode, cheats, levelInfo) -> {
        for (IntegratedServerPublished event : listeners) {
            event.onServerPublished(client, gameMode, cheats, levelInfo);
        }
    });
    public static final Event<OptionsSaved> OPTIONS_SAVED = EventFactory.createArrayBacked(OptionsSaved.class, listeners -> options -> {
        for (OptionsSaved event : listeners) {
            event.onGameOptionsSaved(options);
        }
    });

    private ClientLifecycleEvents() {
    }

    @FunctionalInterface
    public static interface OptionsSaved {
        public void onGameOptionsSaved(class_671 var1);
    }

    @FunctionalInterface
    public static interface IntegratedServerPublished {
        public void onServerPublished(class_669 var1, class_102.class_103 var2, boolean var3, class_102 var4);
    }

    @FunctionalInterface
    public static interface OutOfMemory {
        public void onOutOfMemoryError(class_669 var1);
    }

    @FunctionalInterface
    public static interface ClientStopping {
        public void onClientStopping(class_669 var1);
    }

    @FunctionalInterface
    public static interface ClientStarted {
        public void onClientStarted(class_669 var1);
    }
}

