/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.lifecycle.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1432;
import net.minecraft.class_1637;
import net.minecraft.server.MinecraftServer;

public class ServerPlayerEvents {
    public static final Event<Connect> CONNECT = EventFactory.createArrayBacked(Connect.class, listeners -> (conn, player) -> {
        for (Connect callback : listeners) {
            callback.playerConnect(conn, player);
        }
    });
    public static final Event<Disconnect> DISCONNECT = EventFactory.createArrayBacked(Disconnect.class, listeners -> (conn, player, server) -> {
        for (Disconnect callback : listeners) {
            callback.playerDisconnect(conn, player, server);
        }
    });
    public static final Event<StartTick> START_TICK = EventFactory.createArrayBacked(StartTick.class, listeners -> player -> {
        for (StartTick event : listeners) {
            event.tick(player);
        }
    });
    public static final Event<EndTick> END_TICK = EventFactory.createArrayBacked(EndTick.class, listeners -> player -> {
        for (EndTick event : listeners) {
            event.tick(player);
        }
    });

    private ServerPlayerEvents() {
    }

    public static interface EndTick {
        public void tick(class_1637 var1);
    }

    public static interface StartTick {
        public void tick(class_1637 var1);
    }

    public static interface Disconnect {
        public void playerDisconnect(class_1432 var1, class_1637 var2, MinecraftServer var3);
    }

    public static interface Connect {
        public void playerConnect(class_1432 var1, class_1637 var2);
    }
}

