/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.block.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1405;
import net.minecraft.class_1635;
import net.minecraft.class_348;
import net.minecraft.class_99;

/**
 * Implement this interface on a BlockEntity which you would like to be
 * synchronized with the client side using the built-in engine methods.
 */
public interface BlockEntityClientSerializable {
	void fromClientTag(class_1405 tag);

	class_1405 toClientTag(class_1405 tag);

	/**
	 * When called on the server, schedules a BlockEntity sync to client.
	 * This will cause {@link #toClientTag(class_1405)} to be called on the
	 * server to generate the packet data, and then
	 * {@link #fromClientTag(class_1405)} on the client to decode that data.
	 */
	default void sync() {
		class_99 world = ((class_348) this).method_1112();
		Preconditions.checkNotNull(world); //Maintain distinct failure case from below

		if (!(world instanceof class_1635)) {
			throw new IllegalStateException("Cannot call sync() on the client! Did you check world.isClient() first?");
		}

		((class_1635) world).method_6057().method_6002(((class_348) this).method_1107());
	}
}
