/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.networking.blockentity;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.minecraft.class_1372;
import net.minecraft.class_1405;
import net.minecraft.class_1457;
import net.minecraft.class_1472;
import net.minecraft.class_348;

@Mixin(class_348.class)
public abstract class MixinBlockEntity {
	@Shadow
	public abstract class_1372 getPos();

	@Inject(at = @At("HEAD"), method = "getPacket", cancellable = true)
	public void toUpdatePacket(CallbackInfoReturnable<class_1457<?>> info) {
		Object self = this;

		if (self instanceof BlockEntityClientSerializable) {
			// Mojang's serialization of x/y/z into the update packet is redundant,
			// as we have a separate fromClientTag() we don't do it.
			// However, we use the "id" field for type discernment, as actionId
			// is capped at 8 bits of size with the values presumably reserved
			// by Mojang.

			class_1405 tag = new class_1405();
			String entityId = BlockEntityAccessor.getClassStringMap().get(this.getClass());

			if (entityId == null) {
				throw new RuntimeException(this.getClass() + " is not registered!");
			}

			tag.method_5006("id", entityId);
			tag = ((BlockEntityClientSerializable) self).toClientTag(tag);
			info.setReturnValue(new class_1472(this.getPos(), 127, tag));
			info.cancel();
		}
	}
}
