/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.networking.blockentity;

import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.minecraft.class_1472;
import net.minecraft.class_348;
import net.minecraft.class_903;

@Environment(EnvType.CLIENT)
@Mixin(class_903.class)
public class MixinClientPlayNetworkHandler {
	@Shadow
	@Final
	private static Logger LOGGER;

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/network/packet/s2c/play/BlockEntityUpdateS2CPacket;getBlockEntityId()I", ordinal = 0), method = "onBlockEntityUpdate", cancellable = true, locals = LocalCapture.CAPTURE_FAILHARD)
	public void onBlockEntityUpdate(class_1472 packet, CallbackInfo info, class_348 entity) {
		if (entity instanceof BlockEntityClientSerializable) {
			if (packet.method_5394() == 127) {
				BlockEntityClientSerializable serializable = (BlockEntityClientSerializable) entity;
				String id = packet.method_5395().method_5024("id");

				if (id != null) {
					String otherIdObj = BlockEntityAccessor.getClassStringMap().get(entity.getClass());

					if (otherIdObj == null) {
						LOGGER.error(entity.getClass() + " is not registered!");
						info.cancel();
						return;
					}

					if (otherIdObj.equals(id)) {
						serializable.fromClientTag(packet.method_5395());
					}
				}
			} else {
				throw new RuntimeException("Synced Block Entity sync Id was not 127! This is a bug!");
			}

			info.cancel();
		}
	}
}
