/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.network;

import net.minecraft.class_1435;
import net.minecraft.class_1457;

public interface PacketRegistry {
	class_1457<?> toPacket(PacketIdentifier id, class_1435 buf);

	void register(PacketIdentifier id, PacketConsumer consumer);

	void unregister(PacketIdentifier id);

	/**
	 * @deprecated Use {@link #toPacket(PacketIdentifier, class_1435)} instead!
	 */
	@Deprecated
	class_1457<?> toPacket(String id, class_1435 buf);

	/**
	 * @deprecated Use {@link #register(PacketIdentifier, PacketConsumer)} instead!
	 */
	@Deprecated
	void register(String id, PacketConsumer consumer);

	/**
	 * @deprecated Use {@link #unregister(PacketIdentifier)} instead!
	 */
	@Deprecated
	void unregister(String id);
}
