/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.server;

import java.util.stream.Stream;
import net.minecraft.class_1372;
import net.minecraft.class_1635;
import net.minecraft.class_1637;
import net.minecraft.class_1963;
import net.minecraft.class_348;
import net.minecraft.class_649;
import net.minecraft.class_99;
import net.minecraft.server.MinecraftServer;

public final class PlayerStream {
	private PlayerStream() {
	}

	public static Stream<class_1637> all(MinecraftServer server) {
		if (server.method_6480() != null) {
			return server.method_6480().method_6248().stream();
		} else {
			return Stream.empty();
		}
	}

	public static Stream<class_1963> world(class_99 world) {
		if (!(world instanceof class_1635)) {
			throw new RuntimeException("Only supported on ServerWorld!");
		}

		return ((class_1635) world).field_272.stream();
	}

	public static Stream<class_1963> watching(class_348 entity) {
		return watching(entity.method_1112(), entity.method_1107());
	}

	public static Stream<class_1963> watching(class_99 world, class_1372 pos) {
		if (!(world instanceof class_1635)) {
			throw new RuntimeException("Only supported on ServerWorld!");
		}

		return world(world).filter((player -> ((class_1635) world).method_6057().method_6005((class_1637) player, pos.method_4978(), pos.method_4980())));
	}

	public static Stream<class_1963> around(class_99 world, class_649 vector, double radius) {
		double radiusSq = radius * radius;
		return world(world).filter((p) -> p.method_7023(vector.field_2422, vector.field_2423, vector.field_2424) <= radiusSq);
	}

	public static Stream<class_1963> around(class_99 world, class_1372 pos, double radius) {
		double radiusSq = radius * radius;
		return world(world).filter((p) -> p.method_7023(pos.method_4978(), pos.method_4979(), pos.method_4980()) <= radiusSq);
	}
}
