/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.network;

import java.util.Collection;
import java.util.Collections;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import com.google.common.collect.Sets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.network.S2CPacketTypeCallback;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.PacketIdentifier;
import net.minecraft.class_1435;
import net.minecraft.class_1457;
import net.minecraft.class_1560;
import net.minecraft.class_669;
import net.minecraft.class_903;

@Environment(EnvType.CLIENT)
public class ClientSidePacketRegistryImpl extends PacketRegistryImpl implements ClientSidePacketRegistry {
	private final Collection<String> serverPayloadIds = Sets.newHashSet();

	public static void invalidateRegisteredIdList() {
		((ClientSidePacketRegistryImpl) ClientSidePacketRegistry.INSTANCE).serverPayloadIds.clear();
	}

	@Override
	public boolean canServerReceive(String id) {
		return serverPayloadIds.contains(id);
	}

	@Override
	public boolean canServerReceive(PacketIdentifier id) {
		return this.canServerReceive(id.toString());
	}

	@Override
	public void sendToServer(class_1457<?> packet, GenericFutureListener<? extends Future<? super Void>> completionListener) {
		class_903 handler = class_669.method_2221().method_2316();

		if (handler != null) {
			if (completionListener == null) {
				handler.method_3113(packet);
			} else {
				handler.method_3110().method_5099(packet, completionListener);
			}
		} else {
			LOGGER.warn("Sending packet " + packet + " to server failed, not connected!");
		}
	}

	@Override
	protected void onRegister(String id) {
		class_903 handler = class_669.method_2221().method_2316();

		if (handler != null) {
			createRegisterTypePacket(PacketTypes.REGISTER, Collections.singleton(id)).ifPresent(handler::method_3113);
		}
	}

	@Override
	protected void onUnregister(String id) {
		class_903 handler = class_669.method_2221().method_2316();

		if (handler != null) {
			createRegisterTypePacket(PacketTypes.UNREGISTER, Collections.singleton(id)).ifPresent(handler::method_3113);
		}
	}

	@Override
	protected Collection<String> getIdCollectionFor(PacketContext context) {
		return serverPayloadIds;
	}

	@Override
	protected void onReceivedRegisterPacket(PacketContext context, Collection<String> ids) {
		S2CPacketTypeCallback.REGISTERED.invoker().accept(ids);
	}

	@Override
	protected void onReceivedUnregisterPacket(PacketContext context, Collection<String> ids) {
		S2CPacketTypeCallback.UNREGISTERED.invoker().accept(ids);
	}

	@Override
	public class_1457<?> toPacket(String id, class_1435 buf) {
		return new class_1560(id, buf);
	}

	@Override
	public class_1457<?> toPacket(PacketIdentifier id, class_1435 buf) {
		return this.toPacket(id.toString(), buf);
	}
}
