/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.network;

import java.util.Optional;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.impl.network.ClientSidePacketRegistryImpl;
import net.fabricmc.fabric.impl.network.CustomPayloadPacketAccessor;
import net.fabricmc.fabric.impl.network.PacketRegistryImpl;
import net.minecraft.class_1457;
import net.minecraft.class_1488;
import net.minecraft.class_1502;
import net.minecraft.class_1716;
import net.minecraft.class_1963;
import net.minecraft.class_669;
import net.minecraft.class_903;

@Environment(EnvType.CLIENT)
@Mixin(class_903.class)
public abstract class MixinClientPlayNetworkHandler implements PacketContext {
	@Shadow
	private class_669 client;

	@Shadow
	public abstract void sendPacket(class_1457<?> packet);

	@Inject(method = "onCustomPayload", at = @At("HEAD"), cancellable = true)
	public void onCustomPayload(class_1488 packet, CallbackInfo info) {
		if (((ClientSidePacketRegistryImpl) ClientSidePacketRegistry.INSTANCE).accept(((CustomPayloadPacketAccessor) packet).getChannel(), this, packet::method_5446)) {
			info.cancel();
		}
	}

	@Inject(at = @At("RETURN"), method = "onGameJoin")
	public void onGameJoin(class_1502 packet, CallbackInfo info) {
		Optional<class_1457<?>> optionalPacket = PacketRegistryImpl.createInitialRegisterPacket(ClientSidePacketRegistry.INSTANCE);
		optionalPacket.ifPresent(this::sendPacket);
	}

	@Override
	public EnvType getPacketEnvironment() {
		return EnvType.CLIENT;
	}

	@Override
	public class_1963 getPlayer() {
		return this.client.field_2585;
	}

	@Override
	public class_1716 getTaskQueue() {
		return this.client;
	}
}
