/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.network;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.minecraft.class_1560;
import net.minecraft.class_1637;
import net.minecraft.class_1643;
import net.minecraft.class_1716;
import net.minecraft.class_1963;
import net.minecraft.server.MinecraftServer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.impl.network.CustomPayloadPacketAccessor;
import net.fabricmc.fabric.impl.network.ServerSidePacketRegistryImpl;

@Mixin(class_1643.class)
public class MixinServerPlayNetworkHandler implements PacketContext {
	@Shadow
	public class_1637 player;

	@Shadow
	@Final
	private MinecraftServer server;

	@Inject(method = "onCustomPayload", at = @At("HEAD"), cancellable = true)
	public void onCustomPayload(class_1560 packet, CallbackInfo info) {
		if (((ServerSidePacketRegistryImpl) ServerSidePacketRegistry.INSTANCE).accept(((CustomPayloadPacketAccessor) packet).getChannel(), this, ((CustomPayloadPacketAccessor) packet)::getData)) {
			info.cancel();
		}
	}

	@Override
	public EnvType getPacketEnvironment() {
		return EnvType.SERVER;
	}

	@Override
	public class_1963 getPlayer() {
		return this.player;
	}

	@Override
	public class_1716 getTaskQueue() {
		return this.server;
	}
}
