/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.object.builder.v1.block;

import net.fabricmc.fabric.mixin.object.builder.MaterialAccessor;
import net.minecraft.class_591;
import net.minecraft.class_592;

/**
 * Hooks for creating custom block Materials. Provides implementations for invisible methods and hooks not found in the original class.
 */
public class FabricBlockMaterial extends class_591 {
	private boolean fluid = false;
	private boolean collision = true;
	private boolean translucent = false;
	private boolean blocksMovement = true;

	public FabricBlockMaterial(class_592 color) {
		super(color);
	}

	@Override
	public FabricBlockMaterial method_1804() {
		super.method_1804();
		return this;
	}

	@Override
	public FabricBlockMaterial method_1805() {
		super.method_1805();
		return this;
	}

	@Override
	public FabricBlockMaterial method_1812() {
		super.method_1812();
		return this;
	}

	@Override
	public FabricBlockMaterial method_1813() {
		super.method_1813();
		return this;
	}

	@Override
	public FabricBlockMaterial method_1807() {
		super.method_1807();
		return this;
	}

	public FabricBlockMaterial setAsFluid() {
		this.fluid = true;
		return this;
	}

	public FabricBlockMaterial noCollision() {
		this.collision = false;
		return this;
	}

	public FabricBlockMaterial setTranslucent() {
		this.translucent = true;
		return this;
	}

	public FabricBlockMaterial doesNotBlockMovement() {
		this.blocksMovement = false;
		return this;
	}

	@Override
	public boolean method_1803() {
		return this.fluid;
	}

	@Override
	public boolean method_1800() {
		return this.collision;
	}

	@Override
	public boolean method_1801() {
		return this.translucent;
	}

	@Override
	public boolean method_1802() {
		return this.blocksMovement;
	}

	@Override
	public FabricBlockMaterial method_1814() {
		super.method_1814();
		return this;
	}

	public FabricBlockMaterial method_1816() {
		return (FabricBlockMaterial) ((MaterialAccessor) this).invokeRequiresSilkTouch();
	}
}
