/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.block;

import java.util.function.Predicate;
import net.fabricmc.fabric.api.armor.v1.ArmorMaterial;
import net.minecraft.class_2054;
import net.minecraft.class_2056;

public class ArmorMaterialBuilder {
    private final String name;
    private int enchantability = 10;
    private int durabilityMultiplier = 15;
    private int[] protectionValues = new int[]{2, 5, 4, 1};
    private Predicate<class_2056> repairIngredientPredicate = itemStack -> true;

    public ArmorMaterialBuilder(String name) {
        this.name = name;
    }

    public ArmorMaterialBuilder setDurabilityMultiplier(int durabilityMultiplier) {
        this.durabilityMultiplier = durabilityMultiplier;
        return this;
    }

    public ArmorMaterialBuilder setEnchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public ArmorMaterialBuilder setProtectionValues(int[] protectionValues) {
        this.protectionValues = protectionValues;
        return this;
    }

    public ArmorMaterialBuilder setRepairIngredient(Predicate<class_2056> repairIngredientPredicate) {
        this.repairIngredientPredicate = repairIngredientPredicate;
        return this;
    }

    public ArmorMaterialBuilder setRepairIngredient(class_2054 repairIngredient) {
        return this.setRepairIngredient((class_2056 itemStack) -> itemStack.method_8353() == repairIngredient);
    }

    public ArmorMaterial build() {
        return new ArmorMaterial(){

            public String getName() {
                return ArmorMaterialBuilder.this.name;
            }

            public int getEnchantability() {
                return ArmorMaterialBuilder.this.enchantability;
            }

            public Predicate<class_2056> getRepairIngredient() {
                return ArmorMaterialBuilder.this.repairIngredientPredicate;
            }

            public int getDurabilityMultiplier() {
                return ArmorMaterialBuilder.this.durabilityMultiplier;
            }

            public int getProtectionValue(int slot) {
                return ArmorMaterialBuilder.this.protectionValues[slot];
            }
        };
    }
}

