/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.recipe.v1;

import net.minecraft.class_1963;
import net.minecraft.class_1993;
import net.minecraft.class_2054;
import net.minecraft.class_2056;

public interface FabricRecipeRemainder {
	/**
	 * An {@link class_2056} aware version of {@link class_2054#method_8301()}.
	 *
	 * @param stack The input {@link class_2056} for the current item. Can have metadata values
	 * @param craftingInventory the {@link class_1993} that the stack is part of
	 * @param playerEntity the {@link class_1963} that is crafting the item
	 * @return The {@link class_2056} to remain in the crafting inventory
	 */
	class_2056 getRecipeRemainder(class_2056 stack, class_1993 craftingInventory, class_1963 playerEntity);
}
