/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.recipe.v1;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.impl.base.util.ActionResult;
import net.minecraft.class_1963;
import net.minecraft.class_1993;
import net.minecraft.class_2054;
import net.minecraft.class_2056;

public class RecipeEvents {
	public static final Event<ItemCrafted> ITEM_CRAFTED = EventFactory.createArrayBacked(ItemCrafted.class, (listeners) -> (stack, craftingInventory, playerEntity) -> {
		for (ItemCrafted callback : listeners) {
			ActionResult result = callback.onCraft(stack, craftingInventory, playerEntity);

			if (result != ActionResult.PASS) {
				return result;
			}
		}

		return ActionResult.PASS;
	});

	@FunctionalInterface
	public interface ItemCrafted {
		/**
		 * Called when an item is crafted in a crafting table.
		 *
		 * <p>Upon return:
		 * <ul><li>SUCCESS cancels further processing and executes {@link class_2054#method_8282}.
		 * <li>PASS falls back to further processing.
		 * <li>FAIL cancels further processing and does not execute {@link class_2054#method_8282}.</ul>
		 *
		 * @param stack the {@link class_2056} that is the output of the crafting recipe
		 * @param craftingInventory the {@link class_1993} that will still contain the ingredients for the crafting recipe
		 * @param playerEntity the {@link class_1963} who is crafting the item
		 */
		ActionResult onCraft(class_2056 stack, class_1993 craftingInventory, class_1963 playerEntity);
	}
}
