/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.recipe;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.recipe.v1.FabricRecipeRemainder;
import net.fabricmc.fabric.api.recipe.v1.RecipeEvents;
import net.fabricmc.fabric.impl.base.util.ActionResult;
import net.minecraft.class_1963;
import net.minecraft.class_1993;
import net.minecraft.class_2009;
import net.minecraft.class_2056;

@Mixin(class_2009.class)
public class MixinCraftingResultSlot {
	@Shadow
	@Final
	private class_1993 craftingInv;

	@Shadow
	@Final
	private class_1963 player;

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;onCraft(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;I)V"), method = "onCrafted(Lnet/minecraft/item/ItemStack;)V", cancellable = true)
	public void onCrafted(class_2056 stack, CallbackInfo ci) {
		ActionResult result = RecipeEvents.ITEM_CRAFTED.invoker().onCraft(stack, this.craftingInv, this.player);

		if (result == ActionResult.FAIL) {
			ci.cancel();
		}
	}

	@ModifyVariable(at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/recipe/RecipeDispatcher;getRemainders(Lnet/minecraft/inventory/CraftingInventory;Lnet/minecraft/world/World;)[Lnet/minecraft/item/ItemStack;"), method = "onTakeItem")
	public class_2056[] modifyRemainders(class_2056[] itemStacks) {
		for (int i = 0; i < this.craftingInv.method_6748(); i++) {
			class_2056 invStack = this.craftingInv.method_6736(i);

			if (invStack != null && invStack.method_8353() instanceof FabricRecipeRemainder) {
				itemStacks[i] = ((FabricRecipeRemainder) invStack.method_8353()).getRecipeRemainder(invStack.method_8378(), this.craftingInv, this.player);
			}
		}

		return itemStacks;
	}
}
