/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.render;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.render.v1.BlockEntityRendererRegistry;
import net.minecraft.class_1093;
import net.minecraft.class_1094;
import net.minecraft.class_348;

public class BlockEntityRendererRegistryImpl implements BlockEntityRendererRegistry {
	private Map<Class<? extends class_348>, class_1094<? extends class_348>> renderers = null;
	private Map<Class<? extends class_348>, class_1094<? extends class_348>> renderersTmp = new HashMap<>();

	public void register(Class<? extends class_348> blockEntityClass, class_1094<? extends class_348> blockEntityRenderer) {
		if (renderers != null) {
			renderers.put(blockEntityClass, blockEntityRenderer);
			blockEntityRenderer.method_3751(class_1093.field_4667);
		} else {
			renderersTmp.put(blockEntityClass, blockEntityRenderer);
		}
	}

	public void initialize(class_1093 instance, Map<Class<? extends class_348>, class_1094<? extends class_348>> map) {
		if (renderers != null && renderers != map) {
			throw new RuntimeException("Tried to set renderers twice!");
		}

		if (renderers == map) {
			return;
		}

		renderers = map;

		for (class_1094<? extends class_348> renderer : renderersTmp.values()) {
			renderer.method_3751(instance);
		}

		renderers.putAll(renderersTmp);
		renderersTmp = null;
	}
}
