/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.render;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.fabric.api.client.render.v1.EntityRendererRegistry;
import net.minecraft.class_1135;
import net.minecraft.class_1136;
import net.minecraft.class_1150;
import net.minecraft.class_1232;
import net.minecraft.class_1745;

public class EntityRendererRegistryImpl implements EntityRendererRegistry {
	private final Map<class_1135, Context> renderManagerMap = new WeakHashMap<>();
	private final Map<Class<? extends class_1745>, Factory> renderSupplierMap = new HashMap<>();

	public void initialize(class_1135 dispatcher, class_1232 textureManager, class_1150 itemRenderer, Map<Class<? extends class_1745>, class_1136<? extends class_1745>> map) {
		synchronized (renderSupplierMap) {
			if (renderManagerMap.containsKey(dispatcher)) {
				return;
			}

			Context context = new Context(textureManager, itemRenderer, map);
			renderManagerMap.put(dispatcher, context);

			for (Class<? extends class_1745> c : renderSupplierMap.keySet()) {
				map.put(c, renderSupplierMap.get(c).create(dispatcher, context));
			}
		}
	}

	@Override
	public void register(Class<? extends class_1745> entityClass, Factory factory) {
		synchronized (renderSupplierMap) {
			renderSupplierMap.put(entityClass, factory);

			for (class_1135 manager : renderManagerMap.keySet()) {
				renderManagerMap.get(manager).rendererMap.put(entityClass, factory.create(manager, renderManagerMap.get(manager)));
			}
		}
	}

	public static final class Context {
		private final class_1232 textureManager;
		private final class_1150 itemRenderer;
		private final Map<Class<? extends class_1745>, class_1136<? extends class_1745>> rendererMap;

		private Context(class_1232 textureManager, class_1150 itemRenderer, Map<Class<? extends class_1745>, class_1136<? extends class_1745>> rendererMap) {
			this.textureManager = textureManager;
			this.itemRenderer = itemRenderer;
			this.rendererMap = rendererMap;
		}

		public class_1232 getTextureManager() {
			return textureManager;
		}

		public class_1150 getItemRenderer() {
			return itemRenderer;
		}
	}

	@FunctionalInterface
	public interface Factory {
		class_1136<? extends class_1745> create(class_1135 dispatcher, Context context);
	}
}
