/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.rendering;

import java.util.Map;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.impl.client.render.BlockEntityRendererRegistryImpl;
import net.minecraft.class_1093;
import net.minecraft.class_1094;
import net.minecraft.class_348;

@Environment(EnvType.CLIENT)
@Mixin(class_1093.class)
public class MixinBlockEntityRenderDispatcher {
	@Shadow
	private Map<Class<? extends class_348>, class_1094<? extends class_348>> renderers;

	@Inject(method = "<init>()V", at = @At("RETURN"))
	public void init(CallbackInfo info) {
		((BlockEntityRendererRegistryImpl) BlockEntityRendererRegistry.INSTANCE).initialize((class_1093) (Object) this, renderers);
	}
}
