/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.rendering;

import java.util.Map;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.v1.EntityRendererRegistry;
import net.fabricmc.fabric.impl.client.render.EntityRendererRegistryImpl;
import net.minecraft.class_1135;
import net.minecraft.class_1136;
import net.minecraft.class_1150;
import net.minecraft.class_1232;
import net.minecraft.class_1745;

@Environment(EnvType.CLIENT)
@Mixin(class_1135.class)
public class MixinEntityRenderManager {
	@Shadow
	private Map<Class<? extends class_1745>, class_1136<? extends class_1745>> renderers;

	@Inject(method = "<init>", at = @At("RETURN"), require = 0)
	public void init(class_1232 textureManager, class_1150 itemRenderer, CallbackInfo ci) {
		((EntityRendererRegistryImpl) EntityRendererRegistry.INSTANCE).initialize((class_1135) (Object) this, textureManager, itemRenderer, this.renderers);
	}
}
