/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.impl.resource.loader.DeferredInputStream;
import net.fabricmc.fabric.impl.resource.loader.DeferredNioExecutionHandler;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackUtil;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1245;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModNioResourcePack
extends class_1245
implements ModResourcePack,
Closeable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern RESOURCE_PACK_PATH = Pattern.compile("[a-z0-9-_]+");
    private final ModMetadata modInfo;
    private final Path basePath;
    private final boolean cacheable;
    private final AutoCloseable closer;
    private final String separator;
    private Set<String> namespaceCache;

    public ModNioResourcePack(ModMetadata modInfo, Path path, AutoCloseable closer) {
        super(null);
        this.modInfo = modInfo;
        this.basePath = path.toAbsolutePath().normalize();
        this.cacheable = false;
        this.closer = closer;
        this.separator = this.basePath.getFileSystem().getSeparator();
    }

    private Path getPath(String filename) {
        Path childPath = this.basePath.resolve(filename.replace("/", this.separator)).toAbsolutePath().normalize();
        if (childPath.startsWith(this.basePath) && Files.exists(childPath, new LinkOption[0])) {
            return childPath;
        }
        return null;
    }

    protected InputStream method_4340(String filename) throws IOException {
        InputStream stream;
        if (DeferredNioExecutionHandler.shouldDefer()) {
            stream = DeferredNioExecutionHandler.submit(() -> {
                Path path = this.getPath(filename);
                if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
                    return new DeferredInputStream(Files.newInputStream(path, new OpenOption[0]));
                }
                return null;
            });
            if (stream != null) {
                return stream;
            }
        } else {
            Path path = this.getPath(filename);
            if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
                return Files.newInputStream(path, new OpenOption[0]);
            }
        }
        if ((stream = ModResourcePackUtil.openDefault(this.modInfo, filename)) != null) {
            return stream;
        }
        throw new FileNotFoundException("\"" + filename + "\" in Fabric mod \"" + this.modInfo.getId() + "\"");
    }

    protected boolean method_4341(String filename) {
        if (ModResourcePackUtil.containsDefault(this.modInfo, filename)) {
            return true;
        }
        if (DeferredNioExecutionHandler.shouldDefer()) {
            try {
                return DeferredNioExecutionHandler.submit(() -> {
                    Path path = this.getPath(filename);
                    return path != null && Files.isRegularFile(path, new LinkOption[0]);
                });
            }
            catch (IOException e) {
                return false;
            }
        }
        Path path = this.getPath(filename);
        return path != null && Files.isRegularFile(path, new LinkOption[0]);
    }

    protected void warnInvalidNamespace(String s) {
        LOGGER.warn("Fabric NioResourcePack: ignored invalid namespace: {} in mod ID {}", new Object[]{s, this.modInfo.getId()});
    }

    public Set<String> method_4372() {
        if (this.namespaceCache != null) {
            return this.namespaceCache;
        }
        try {
            Path typePath = this.getPath("assets");
            if (typePath == null || !Files.isDirectory(typePath, new LinkOption[0])) {
                return Collections.emptySet();
            }
            HashSet<String> namespaces = new HashSet<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(typePath, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                for (Path path : stream) {
                    String s = path.getFileName().toString();
                    if (RESOURCE_PACK_PATH.matcher(s = s.replace(this.separator, "")).matches()) {
                        namespaces.add(s);
                        continue;
                    }
                    this.warnInvalidNamespace(s);
                }
            }
            if (this.cacheable) {
                this.namespaceCache = namespaces;
            }
            return namespaces;
        }
        catch (IOException e) {
            LOGGER.warn("getNamespaces in mod " + this.modInfo.getId() + " failed!", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public ModMetadata getFabricModMetadata() {
        return this.modInfo;
    }

    public String method_4370() {
        return ModResourcePackUtil.getName(this.modInfo);
    }
}

